@extends ('../welcome')


@section('content')

    <div class="card card-info">
        <div class="card-header">
            <h3 class="card-title">Open Ticket</h3>
        </div>
        <!-- /.card-header -->
        <div class="row">
            <div class="col-3">

            </div>
            <div class="card-body ">
                <form action="{{ route('tickets.store') }}" method="post" enctype="multipart/form-data">
                    @csrf

                    <div class="col-sm-6">
                        <!-- text input -->
                        <meta name="csrf-token" content="{{ csrf_token() }}">

                        <div class="form-group">
                            <label for="projects">Select Project</label>
                            <select name="project_id" id="projects" class="custom-select form-control-border"required>
                                <option></option>
                                @foreach ($projects as $project)
                                    <option value="{{ $project->id }}">{{ $project->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="unit_id">Choose unit</label>
                            <select name="unit_id" id="units" class="select2 custom-select form-control-border"
                                required>

                            </select>
                        </div>
                        <div class="form-group">
                            <label>Description</label>
                            <textarea id='Description' name="description" class="form-control" placeholder="Ticket Descrption" required></textarea>
                        </div>

                        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('tickets-assignUser'))
                            <div class="form-group">
                                <label for="users">Assign To</label>
                                <select name="user_id" id="users" class="select2 custom-select form-control-border">
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            @else 
                            <input type="hidden" name="user_id" value={{auth()->user()->id}}>
                        @endif
                        
                        <div class="form-group">
                            <label for="methods">Communication Method</label>
                            <select name="method_id" id="methods" class="select2 custom-select form-control-border">
                                @foreach ($methods as $method)
                                    <option value="{{ $method->id }}">{{ $method->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="types">Ticket Type</label>
                            <select name="ticket_type_id" id="types" class="select2 custom-select form-control-border">
                                @foreach ($types as $type)
                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="tags">Tags</label>
                            <select name="tag_id" id="tags" class="select2 custom-select form-control-border">
                                @foreach ($tags as $tag)
                                    <option value="{{ $tag->id }}">{{ $tag->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="call_date">Call Date</label>
                            <input name="call_date" type="date" value="{{ date('Y-m-d') }}" class="form-control">
                        </div>
                        <div class="form-group">
                            <label for="Files">Related Files / Images</label>
                            <input name="files[]" type="file" multiple>
                        </div>
                    </div>

                    <div class="card-footer col-6">
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        <!-- /.card-body -->
    </div>
    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>

    <script>
        $(document).on('change', '#projects', function() {
            // console.log(this.value);
            var data = this.value;

            $.ajax({
                data: {
                    'project_id': data
                },
                method: "POST",
                url: "{{ route('projectUnits') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    console.log(dataResult.units);
                    let units = "";


                    Array.from(dataResult.units).forEach(myFunction2);

                    function myFunction2(item, index) {
                        units += `<option value="` + item.id + `">` + item.name + `</option>`;
                    }
                    document.getElementById("units").innerHTML = units;
                }
            });
        });
    </script>
@endsection
