@extends ('../welcome')
@section('content')

    <div class="row">
        {{-- Basic Data Card --}}
        <div class="card col-6" style="margin-right:20px;">
            <div class="card-header">
                <div class="card-title">
                    <h4>
                        {{ $ticket->unit->name }} - {{ $ticket->client->name }}
                    </h4>
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    @if ($ticket->status != 'done')
                        {{-- Re-Assign User --}}
                        <div class="col-6">
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('tickets-assignUser'))
                                <form action="{{ route('reAssignUser', $ticket->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    <label>Re-assign User</label><br>
                                    <div class="row">
                                        <select name="user_id" class="select2 custom-select form-control-border col-5">
                                            @foreach ($users as $user)
                                                <option value="{{ $user->id }}" {{$ticket->assigned_to->id == $user->id ? 'selected' : ''}}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                        <button type="submit" class="btn btn-info">Change</button>
                                    </div>
                                </form>
                            @endif
                        </div>
                        {{-- Change Status --}}
                        <div class="col-6">
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('tickets-changeStatus'))
                                <form action="{{ route('TicketChangeStatus', $ticket->id) }}" method="POST">
                                    @csrf
                                    @method('PUT')
                                    <label>Change Status</label><br>
                                    @if ($ticket->status == 'pending')
                                        <select name="status" class="custom-select form-control-border col-6">
                                            <option value="follow_up">follow up</option>
                                            <option value="done">Done</option>
                                        </select>
                                    @else
                                        <select name="status" class="custom-select form-control-border col-6">
                                            <option value="done">Done</option>
                                        </select>
                                    @endif
                                    <button type="submit" class="btn btn-danger">Change</button>
                                </form>
                            @endif
                        </div>
                    @endif
                </div>
                <hr>
                {{-- Ticket Data --}}
                <table>
                    <tr>
                        <th>ID :</th>
                        <td>
                            {{ $ticket->id }}
                            <span style="color:#dc3545">{{ $ticket->delay == 1 ? 'Delay ticket' : '' }}</span>
                        </td>
                    </tr>
                    <tr>
                        <th>Client ID :</th>
                        <td>
                            <a href="{{ route('clients.show', $ticket->client->id) }}">
                                {{ $ticket->client->name }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Assigned User:</th>
                        <td>
                            <a href="{{ route('users.show', $ticket->assigned_to->id) }}">
                                {{ $ticket->assigned_to->name }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Created By:</th>
                        <td>
                            <a href="{{ route('users.show', $ticket->user_id) }}">
                                {{ $ticket->ticket_created_by->name }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Project:</th>
                        <td>
                            <a href="{{ route('projects.show', $ticket->project->id) }}">
                                {{ $ticket->project->name }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Unit:</th>
                        <td>
                            <a href="{{ route('units.show', $ticket->unit->id) }}">
                                {{ $ticket->unit->name }}
                            </a>
                        </td>
                    </tr>
                    <tr>
                        <th>Description:</th>
                        <td>
                            {{ $ticket->description }}
                        </td>
                    </tr>
                    <tr>
                        <th>Communication Method :</th>
                        <td>
                            {{ $ticket->method->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>Ticket Type :</th>
                        <td>
                            {{ $ticket->ticket_type->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>Status :</th>
                        <td>
                            {{ $ticket->status }}
                        </td>
                    </tr>
                    <tr>
                        <th>Call Date:</th>
                        <td>
                            {{ Carbon\Carbon::parse($ticket->call_date)->format('Y-m-d') ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>Created at :</th>
                        <td>
                            {{ Carbon\Carbon::parse($ticket->created_at)->format('Y-m-d H:i:s') ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>Deadline :</th>
                        <td>
                            {{ Carbon\Carbon::parse($ticket->deadline)->format('Y-m-d') ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>Total Impression :</th>
                        <td>
                            {{ $ticket->client->tag?->name ?? '' }}
                        </td>
                    </tr>
                </table>
                @if (count($ticket->files) != 0)
                    <hr>
                    <span style="font-weight:bold;">Attached Files</span><br>
                    <div class="row">
                        @foreach ($ticket->files as $file)
                            <li class="col-3">
                                <a href="{{ url('/images/' . $file->file) }}">{{ $file->file }}</a>
                            </li>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        {{-- Notes || Comments Card --}}
        <div class="card card-outline col-5">
            <div class="card-header">
                {{-- Comment Form --}}
                @if ($ticket->status != 'done')
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('tickets-createComment'))
                        <form action="{{ route('comments.store') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                <div class="col-sm-12">
                                    <!-- text input -->
                                    <input type="hidden" name="ticket_id" value="{{ $ticket->id }}">
                                    <div class="form-group">
                                        <label>Comment</label>
                                        <textarea type="text" name="description" class="form-control" required></textarea>
                                    </div>
                                </div>
                                <input type="hidden" name="comment_status" value="{{ $ticket->status }}">
                                <input type="hidden" name="created_by" value="{{ auth()->user()->id }}">
                                <input type="hidden" name="ticket_id" value="{{ $ticket->id }}">
                            </div>
                            <div class="form-group">
                                <label for="Files">Related Files / Images</label>
                                <input name="files[]" type="file" multiple>
                            </div>

                            <button type="submit" class="btn btn-info" style="float:right">
                                submit
                            </button>

                        </form>
                    @endif
                @endif
            </div>

            {{-- Comments --}}
            <div class="card-body" style="overflow-y: scroll;height:410px;">
                @foreach ($ticket->comments as $comment)
                    <table>
                        <tr>
                            <th> Description :</th>
                            <td>{{ $comment->description }}</td>
                        </tr>
                        <tr>
                            <th>Status :</th>
                            <td>{{ $comment->status }}</td>
                        </tr>
                        <tr>
                            <th>Created by :</th>
                            <td>
                                {{ $comment->user->id ?? '' }} -
                                {{ $comment->user->name ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <th>Date :</th>
                            <td>
                                {{ Carbon\Carbon::parse($comment->created_at)->format('Y-m-d H:i:s') ?? '' }}
                            </td>
                        </tr>
                        @if (isset($comment->files) != 0)
                            <tr>
                                <th>Files: </th>
                                <td>
                                    @foreach ($comment->files as $file)
                                        <li>
                                            <a href="{{ url('/images/' . $file->file) }}">{{ $file->file }}</a>
                                        </li>
                                    @endforeach
                                </td>
                            </tr>
                        @endif
                    </table>
                    <hr>
                @endforeach
            </div>
        </div>
    </div>
    <hr>
    {{-- Ticket Actions Table --}}
    <div class="col-12">
        <table
            id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('ticket-history-export')? 'example1': 'nonExport' }}
            class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Ticket ID</th>
                    <th>Ticket Creator</th>
                    <th>Ticket Type</th>
                    <th>Ticket Creation Date</th>
                    <th>Client Name</th>
                    <th>Client Mobile</th>
                    <th>Action</th>
                    <th>Details</th>
                    <th>Assigned User</th>
                    <th>Action created at</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($actions as $action)
                    {{-- @if ($action->event == 'follow_up' || $action->event == 'done' || $action->event == 'Create' || $action->event == 'Assign-User') --}}
                    <?php $action_created_at = explode(' ', $action->created_at->setTimezone('Africa/Cairo')); ?>
                    <?php $ticket_created_at = explode(' ', $action->ticket->created_at->setTimezone('Africa/Cairo')); ?>
                    <tr>
                        <td>{{ $action->ticket_id ?? '' }}</td>
                        <td>
                            {{ $action->created_by?->name ?? '' }}
                        </td>

                        <td>
                            {{ $action->ticket->ticket_type?->name ?? '' }}
                        </td>
                        <td>
                            {{ Carbon\Carbon::parse($action->ticket->created_at)->format('Y-m-d H:i:s') ?? '' }}
                        </td>
                        <td>
                            {{ $action->client->name ?? '' }}
                        </td>
                        <td>
                            @if($action->client && $action->client->phone_numbers)
                                @foreach ($action->client->phone_numbers as $phone)
                                    <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                        {{ $phone->country->phonecode }} {{ $phone->phone }}
                                    </a>
                                    <br>
                                @endforeach
                            @else
                                --
                            @endif
                        </td>
                        <td>
                            {{ $action->action_type ?? '' }}
                        </td>
                        <td>
                            {{ $action->details ?? '' }}
                        </td>
                        <td>
                            {{ $action->assigned_user_name ?? '' }}
                        </td>
                        <td>
                            {{ Carbon\Carbon::parse($action->created_at)->format('Y-m-d H:i:s') ?? '' }}
                        </td>

                        {{-- <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td> --}}
                    </tr>
                    {{-- @endif --}}
                @endforeach
            </tbody>
        </table>
    </div>
    <br>



@endsection
