@extends ('../welcome')

@section('content')
    <style>
        h4 {
            font-weight: bold;
            color: #17a2b8;
        }

        .modal-xl {
            max-width: 80% !important;
        }
    </style>
    <div class="card">
        <div class="card-header">
            <div class="row">
                <h4 class="col-11">Manage Unit Settings</h4>
                <button type="button" class="btn btn-info btn-md" data-toggle="modal" data-target="#myModal"
                    style="float:right">
                    <i class="fas fa-code"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="row" style="justify-content:space-evenly">
                <div class="card col-3">
                    <!-- Residential -->
                    <div class="card-header">
                        <div class="row">
                            <h4 class="col-10">Residential Types</h4>
                            <button id="ResidentialAddRow" type="button" class="btn btn-light">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="ResidentialInputFormRow">
                            <div class="row">
                                @forelse($residentials as $residential)
                                    <div class="col-10">
                                        <input type="text" class="form-control m-input" value="{{ $residential->name }}"
                                            readonly>
                                    </div>
                                    <div class="col-2">
                                        @if (count($residential->unitType) == 0)
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $residential->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <br><br>
                                @empty
                                @endforelse
                            </div>
                            <form action="{{ route('unitSettings.store') }}" method="POST">
                                @csrf
                                <div id="ResidentialNewRow"></div>
                        </div>
                        <div class="card-footer" style="display:flex;justify-content:center;">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>
                
                <div class="card col-3">
                    <!-- Medical -->
                    <div class="card-header">
                        <div class="row">
                            <h4 class="col-10">Medical Types</h4>
                            <button id="MedicalAddRow" type="button" class="btn btn-light">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="MedicalInputFormRow">
                            <div class="row">
                                @forelse($medicals as $medical)
                                    <div class="col-10">
                                        <input type="text" class="form-control m-input" value="{{ $medical->name }}"
                                            readonly>
                                    </div>
                                    <div class="col-2">
                                        @if (count($medical->unitType) == 0)
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $medical->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <br><br>
                                @empty
                                @endforelse
                            </div>
                            <form action="{{ route('unitSettings.store') }}" method="POST">
                                @csrf
                                <div id="MedicalNewRow"></div>
                        </div>
                        <div class="card-footer" style="display:flex;justify-content:center;">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>

                <div class="card col-3">
                    <!-- Commercial -->
                    <div class="card-header">
                        <div class="row">
                            <h4 class="col-10">Commercial Types</h4>
                            <button id="CommercialAddRow" type="button" class="btn btn-light">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="CommercialInputFormRow">
                            <div class="row">
                                @forelse($commercials as $commercial)
                                    <div class="col-10">
                                        <input type="text" class="form-control m-input" value="{{ $commercial->name }}"
                                            readonly>
                                    </div>
                                    <div class="col-2">
                                        @if (count($commercial->unitType) == 0)
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $commercial->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <br><br>
                                @empty
                                @endforelse
                            </div>
                            <form action="{{ route('unitSettings.store') }}" method="POST">
                                @csrf
                                <div id="CommercialNewRow"></div>
                        </div>
                        <div class="card-footer" style="display:flex;justify-content:center;">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>

                <div class="card col-3">
                    <!-- Administrative -->
                    <div class="card-header">
                        <div class="row">
                            <h4 class="col-10">Administrative Types</h4>
                            <button id="AdministrativeAddRow" type="button" class="btn btn-light">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="AdministrativeInputFormRow">
                            <div class="row">
                                @forelse($administratives as $administrative)
                                    <div class="col-10">
                                        <input type="text" class="form-control m-input"
                                            value="{{ $administrative->name }}" readonly>
                                    </div>
                                    <div class="col-2">
                                        @if (count($administrative->unitType) == 0)
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $administrative->id }}"
                                                data-toggle="modal" data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <br><br>
                                @empty
                                @endforelse
                            </div>
                            <form action="{{ route('unitSettings.store') }}" method="POST">
                                @csrf
                                <div id="AdministrativeNewRow"></div>
                        </div>
                        <div class="card-footer" style="display:flex;justify-content:center;">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="row" style="justify-content:space-evenly">

                <div class="card col-3">
                    <!-- Finishing -->
                    <div class="card-header">
                        <div class="row">
                            <h4 class="col-10">Finishing Types</h4>
                            <button id="FinishingAddRow" type="button" class="btn btn-light">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="FinishingInputFormRow">
                            <div class="row">
                                @forelse($finishings as $finishing)
                                    <div class="col-10">
                                        <input type="text" class="form-control m-input" value="{{ $finishing->name }}"
                                            readonly>
                                    </div>
                                    <div class="col-2">
                                        @if (count($finishing->unitFinishing) == 0)
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $finishing->id }}"
                                                data-toggle="modal" data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <br><br>
                                @empty
                                @endforelse
                            </div>
                            <form action="{{ route('unitSettings.store') }}" method="POST">
                                @csrf
                                <div id="FinishingNewRow"></div>
                        </div>
                        <div class="card-footer" style="display:flex;justify-content:center;">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>

                <div class="card col-3">
                    <!-- View -->
                    <div class="card-header">
                        <div class="row">
                            <h4 class="col-10">View Types</h4>
                            <button id="ViewAddRow" type="button" class="btn btn-light">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div id="ViewInputFormRow">
                            <div class="row">
                                @forelse($views as $view)
                                    <div class="col-10">
                                        <input type="text" class="form-control m-input" value="{{ $view->name }}"
                                            readonly>
                                    </div>
                                    <div class="col-2">
                                        @if (count($view->unitView) == 0)
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $view->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </div>
                                    <br><br>
                                @empty
                                @endforelse
                            </div>
                            <form action="{{ route('unitSettings.store') }}" method="POST">
                                @csrf
                                <div id="ViewNewRow"></div>
                        </div>
                        <div class="card-footer" style="display:flex;justify-content:center;">
                            <button type="submit" class="btn btn-info">Submit</button>
                        </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog  modal-lg modal-dialog-centered" role="document">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table id="example1" class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <th>type</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($unit_codes as $code)
                                <tr>
                                    <td>
                                        {{ $code->id }}
                                    </td>
                                    <td>
                                        {{ $code->name }}
                                    </td>
                                    <td>
                                        {{ $code->type }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>

        </div>
    </div>


    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // Residential
        $("#ResidentialAddRow").click(function() {
            var html = '';
            html += `
            <div id="ResidentialInputFormRow">
                <div class="row" style="margin-top:20px;">
                    <div class="col-10">
                    <input type="hidden" name="type[]" value="residential">
                        <input type="text" class="form-control m-input"
                                name="name[]" required>
                    </div>
                    <div class="col-2">
                        <button id="ResidentialRemoveRow" type="button" class="btn btn-danger">
                        <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            </div>`;

            $('#ResidentialNewRow').append(html);
        });

        // remove row
        $(document).on('click', '#ResidentialRemoveRow', function() {
            $(this).closest('#ResidentialInputFormRow').remove();
        });
        
        // Medical
        $("#MedicalAddRow").click(function() {
            var html = '';
            html += `
            <div id="MedicalInputFormRow">
                <div class="row" style="margin-top:20px;">
                    <div class="col-10">
                    <input type="hidden" name="type[]" value="medical">
                        <input type="text" class="form-control m-input"
                                name="name[]" required>
                    </div>
                    <div class="col-2">
                        <button id="MedicalRemoveRow" type="button" class="btn btn-danger">
                        <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            </div>`;

            $('#MedicalNewRow').append(html);
        });

        // remove row
        $(document).on('click', '#MedicalRemoveRow', function() {
            $(this).closest('#MedicalInputFormRow').remove();
        });

        // Commercial

        $("#CommercialAddRow").click(function() {
            var html = '';
            html += `
    <div id="CommercialInputFormRow">
        <div class="row" style="margin-top:20px;">
            <div class="col-10">
            <input type="hidden" name="type[]" value="commercial">
                <input type="text" class="form-control m-input" 
                        name="name[]" required>
            </div>
            <div class="col-2">
                <button id="CommercialRemoveRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#CommercialNewRow').append(html);
        });

        // remove row
        $(document).on('click', '#CommercialRemoveRow', function() {
            $(this).closest('#CommercialInputFormRow').remove();
        });

        // Administrative

        $("#AdministrativeAddRow").click(function() {
            var html = '';
            html += `
    <div id="AdministrativeInputFormRow">
        <div class="row" style="margin-top:20px;">
            <div class="col-10">
            <input type="hidden" name="type[]" value="administrative">

                <input type="text" class="form-control m-input" 
                        name="name[]" required>
            </div>
            <div class="col-2">
                <button id="AdministrativeRemoveRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#AdministrativeNewRow').append(html);
        });

        // remove row
        $(document).on('click', '#AdministrativeRemoveRow', function() {
            $(this).closest('#AdministrativeInputFormRow').remove();
        });

        // Finishing

        $("#FinishingAddRow").click(function() {
            var html = '';
            html += `
    <div id="FinishingInputFormRow">
        <div class="row" style="margin-top:20px;">
            <div class="col-10">
            <input type="hidden" name="type[]" value="finishing">

                <input type="text" class="form-control m-input" 
                        name="name[]" required>
            </div>
            <div class="col-2">
                <button id="FinishingRemoveRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#FinishingNewRow').append(html);
        });

        // remove row
        $(document).on('click', '#FinishingRemoveRow', function() {
            $(this).closest('#FinishingInputFormRow').remove();
        });

        // View

        $("#ViewAddRow").click(function() {
            var html = '';
            html += `
    <div id="ViewInputFormRow">
        <div class="row" style="margin-top:20px;">
            <div class="col-10">
            <input type="hidden" name="type[]" value="view">

                <input type="text" class="form-control m-input" 
                        name="name[]" required>
            </div>
            <div class="col-2">
                <button id="ViewRemoveRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#ViewNewRow').append(html);
        });

        // remove row
        $(document).on('click', '#ViewRemoveRow', function() {
            $(this).closest('#ViewInputFormRow').remove();
        });

        clickDeletebutton = (e) => {
            let modelId = e.getAttribute("data-id");
            console.log(modelId);
            var route = "{{ route('unitSettings.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
