@extends ('../welcome')


@section('content')

    <div class="card card-info col-6">
        <div class="card-body">
            <form action="{{ route('units.store') }}" method="post">
                @csrf
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group">
                            <label>Name</label>
                            <input type="text" name="name" class="form-control" placeholder="Unit Name" required>
                        </div>
                    </div>
                </div>

                <div class="row">
                    @if ($building->phase->project->is_residential == 1)
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label class="col-3">floor</label>
                                <select name='floor' id="floor" class="form-control col-6" style="width: 100%;">
                                    <option value="0">G</option>
                                    @for ($i = 1; $i <= $building->number_of_floors; $i++)
                                        <option value="{{ $i }}">{{ $i }}</option>
                                    @endfor
                                </select>
                            </div>
                        </div>
                    @else
                        <input type="hidden" name="floor" value="0">
                    @endif
                    <div class="form-group col-3">
                        <input type="checkbox" id="roof" name="has_roof" style="width:25px;height:25px;">
                        <label style="margin-left:10px;" for="roof">Has Roof ?</label>
                    </div>
                </div>

                @if ($building->type != 'Administrative')
                    <!-- <h5 style="color:red; font-weight:bold;font-style: italic;">Garden and Out-Areas Only Available For Floor 1</h5> -->
                    <div class="row">
                        <div id="ground">
                            <div class="form-group">
                                <label>{{ $building->type == 'Residential' ? 'Garden Space' : 'Out-area Space ' }}</label>
                                <input type="number" step="any" name="garden_space" class="form-control"
                                    placeholder="00">
                            </div>
                        </div>
                        <div id="roof-space" style="display:none; margin-right: 15%px;">
                            <div class="form-group">
                                <label>Roof Space</label>
                                <input type="number" step="any" name="roof_space" class="form-control"
                                    placeholder="00">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label>Unit Space</label>
                                <input type="number" step="any" name="unit_space" class="form-control" placeholder="00"
                                    required>
                            </div>
                        </div>
                        
                    </div>
                @endif
                {{-- unit price for 7 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 7 years</label>
                            <input type="number" step="any" name="unit_meter_price" class="form-control" value="0"
                                required>
                        </div>
                    </div>
                    <div id="total_price" style="margin-right: 15%px;">
                        <div class="form-group">
                            <label>Unit Total Price for 7 years</label>
                            <input type="number" step="any" name="unit_total_price" class="form-control"
                                placeholder="00">
                        </div>
                    </div>
                </div>
                {{-- unit price for cash --}}
                {{--<div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for cash</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=0>
                        </div>
                    </div>
                </div>--}}

                {{-- unit price for 1 year --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 1 year</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=1>
                        </div>
                    </div>
                </div>
                {{-- unit price for 2 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 2 years</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=2>
                        </div>
                    </div>
                </div>
                {{-- unit price for 3 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 3 years</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=3>
                        </div>
                    </div>
                </div>
                
                {{-- unit price for 4 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 4 years</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=4>
                        </div>
                    </div>
                </div>

                {{-- unit price for 5 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 5 years</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=5>

                        </div>
                    </div>
                </div>

                {{-- unit price for 6 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 6 years</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=6>

                        </div>
                    </div>
                </div>

                {{-- unit price for 8 years --}}
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            <label>Unit Meter Price for 8 years</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0"
                                required>
                                <input type="hidden" name="years[]" value=8>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <input type="hidden" step="any" name="basement_space" value="0" class="form-control"
                        placeholder="Basement Space">
                </div>

                @if ($building->type == 'Residential' || 'Multiple')
                    @if ($building->phase->project->is_residential == 1)
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label>BedRooms</label>
                                    <input type="number" name="bedrooms" class="form-control" placeholder="0">
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label>BathRooms</label>
                                    <input type="number" name="bathrooms" class="form-control" placeholder="0">
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label>Dressing</label>
                                    <input type="number" name="dressing" class="form-control" placeholder="0">
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea name="description" id="description" cols="30" rows="4" class="form-control"
                                    placeholder="Description"></textarea>
                            </div>
                        </div>
                    </div>
                @endif

                <input class="form-check-input" name="is_active" value="1" type="hidden">

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>View</label>
                            <select name='view' class="form-control select2" style="width: 100%;">
                                @foreach ($views as $view)
                                    <option value="{{ $view->id }}">{{ $view->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Type</label>
                            <select name='type' class="form-control select2" style="width: 100%;">
                                @foreach ($types as $type)
                                    <option value="{{ $type->id }}">{{ $type->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Finishing</label>
                            <select name='finishing' class="form-control select2" style="width: 100%;">
                                @foreach ($finishings as $finishing)
                                    <option value="{{ $finishing->id }}">{{ $finishing->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <input type="hidden" name="building_id" value="{{ $_GET['id'] }}">
                        <button type="submit" class="btn btn-info" style="float:right">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#floor').on('change', () => {
                let floor = $('#floor option:selected').text();
                if (floor == 'G') {
                    $("#ground").show();
                } else {
                    $("#ground").hide();
                }
            });

            $('input[type="checkbox"]').click(function() {
                if ($(this).prop("checked") == true) {
                    $("#roof-space").show();
                } else {
                    $("#roof-space").hide();

                }
            });

        });
    </script>
@endsection