@extends ('../welcome')


@section ('content')

<div class="card card-info">

    <!-- /.card-header -->
    <div class="card-body">
        <form action="{{ route('units.update', $unit->id) }}" method="post">
            @csrf
            @method('PUT')
            <input type="hidden" name="is_active" value="{{$unit->is_active}}">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" value="{{$unit->name ?? ''}}" required>
                    </div>
                </div>
            </div>

            <div class="row">
                @if($unit->building->phase->project->is_residential == 1)
                <div class="col-md-3">
                    <div class="form-group row">
                        <label class="col-3">floor</label>
                        <select name='floor' id="floor" class="form-control col-6" style="width: 100%;">
                            <<option value="0">G</option>
                            @for($i=1; $i <= $unit->building->number_of_floors; $i++)
                                <option value="{{$i}}" {{$unit->floor == $i ? 'selected' : ''}}>{{$i}}</option>
                                @endfor
                        </select>
                    </div>
                </div>
                @else
                <input type="hidden" value="0" name="floor" id="floorVal">
                @endif
                <div class="form-group col-3">
                    <input type="checkbox" id="roof" {{$unit->roof_space != 0 ? 'checked' : ''}} name="has_roof" style="width:25px;height:25px;">
                    <label style="margin-left:10px;" for="roof">Has Roof ?</label>
                </div>
            </div>

            <!-- <h5 style="color:red; font-weight:bold;font-style: italic;">Garden and Out-Areas Only Available For Floor 1</h5> -->
            <div class="row">
                
                <div id="{{$unit->building->phase->project->is_residential == 0 ? '' : 'ground'}}">
                    <div class="form-group">
                        <label>{{$building->type == 'Residential'? 'Garden Space' : 'Out-area Space '}}</label>
                        <input type="number" step="any" name="garden_space" value="{{$unit->garden_space ?? ''}}" class="form-control" placeholder="00">
                    </div>
                </div>
                
                <div id="roof-space" style="display:none; margin-right: 15%px;">
                    <div class="form-group">
                        <label>Roof Space</label>
                        <input type="number" step="any" name="roof_space" value="{{$unit->roof_space ?? ''}}" class="form-control" placeholder="00">
                    </div>
                </div>
                <div id="unit-space" style="margin-right: 15%px;">
                    <div class="form-group">
                        <label>Unit Total Price</label>
                        <input type="number" step="any" name="unit_total_price" value="{{$unit->unit_total_price ?? ''}}" class="form-control" placeholder="00">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>Unit Space</label>
                        <input type="number" step="any" name="unit_space" class="form-control"
                            value="{{$unit->unit_space ?? '' }}" required>
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>Unit Meter Price</label>
                        <input type="number" step="any" name="unit_meter_price" class="form-control"
                            value="{{$unit->unit_meter_price ?? 0}}" required>
                    </div>
                </div>
            </div>
            {{-- unit price for cash --}}
            {{--<div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for cash</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value="{{$unit->prices[0]->meter_price ?? ''}}"
                            required>
                            <input type="hidden" name="years[]" value=0>
                    </div>
                </div>
            </div>--}}
            {{-- unit price for 1 year --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 1 year</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value="{{$unit->prices[0]->meter_price ?? ''}}"
                            required>
                            <input type="hidden" name="years[]" value=1>
                    </div>
                </div>
            </div>
            {{-- unit price for 2 years --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 2 years</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value="{{$unit->prices[1]->meter_price ?? ''}}"
                            required>
                            <input type="hidden" name="years[]" value=2>
                    </div>
                </div>
            </div>
            {{-- unit price for 3 years --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 3 years</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value="{{$unit->prices[2]->meter_price ?? ''}}"
                            required>
                            <input type="hidden" name="years[]" value=3>
                    </div>
                </div>
            </div>
            {{-- unit price for 4 years --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 4 years</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value={{$unit->prices[3]->meter_price ?? ''}}
                            required>
                            <input type="hidden" name="years[]" value=4>
                    </div>
                </div>
            </div>

            {{-- unit price for 5 years --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 5 years</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value={{$unit->prices[4]->meter_price ?? ''}}
                            required>
                            <input type="hidden" name="years[]" value=5>

                    </div>
                </div>
            </div>

            {{-- unit price for 6 years --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 6 years</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value={{$unit->prices[5]->meter_price ?? ''}}
                            required>
                            <input type="hidden" name="years[]" value=6>

                    </div>
                </div>
            </div>
            {{-- unit price for 8 years --}}
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Unit Meter Price for 8 years</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value={{$unit->prices[6]->meter_price ?? ''}}
                            required>
                            <input type="hidden" name="years[]" value=8>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>BedRooms</label>
                        <input type="number" name="bedrooms" class="form-control" value="{{$unit->bedrooms ?? ''}}">
                    </div>
                </div>
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>BathRooms</label>
                        <input type="number" name="bathrooms" class="form-control" value="{{$unit->bathrooms ?? ''}}"
                        >
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-3">
                    <div class="form-group">
                        <label>Dressing</label>
                        <input type="number" name="dressing" class="form-control" value="{{$unit->dressing ?? ''}}">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Description</label>
                        <textarea name="description" id="description" cols="30" rows="4" class="form-control"
                            placeholder="Description">{{$unit->description}}</textarea>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>View</label>
                        <select name='view' class="form-control select2" style="width: 100%;">
                            @foreach($views as $view)
                            <option {{$view->id == $unit->vieww?->id ? 'selected' : ''}} value="{{$view->id}}">
                                {{$view->name}}</option>
                            @endforeach

                        </select>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Type</label>
                        <select name='type' class="form-control select2" style="width: 100%;">
                            
                            @foreach($types as $type)
                            <option value="{{$type->id}}" {{$type->id == $unit->typee?->id ? 'selected' : ''}}>
                                {{$type->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label>Finishing</label>
                        <select name='finishing' class="form-control select2" style="width: 100%;">
                           
                            @foreach($finishings as $finishing)
                            <option {{$finishing->id == $unit->finishingLevel?->id ? 'selected' : ''}} value="{{$finishing->id}}">
                                {{$finishing->name}}</option>
                            @endforeach

                        </select>
                    </div>
                </div>
            </div>


            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
    <!-- /.card-body -->
</div>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
$(document).ready(function() {
    
    let Oldfloor = $('#floor option:selected').text();

    if (Oldfloor != 'G') {
        $("#ground").hide();
    }

    $('#floor').on('change', () => {
        let newFloor = $('#floor option:selected').text();

        if (newFloor == 'G') {
            $("#ground").show();
        } else {
            $("#ground").hide();
        }
    });

    
    
    
    
    $('input[type="checkbox"]').click(function() {
        if ($(this).prop("checked") == true) {
            $("#roof-space").show();
        } else {
            $("#roof-space").hide();

        }
    });

});
</script>

@endsection