@extends ('../welcome')
@section ('content')
<style>
    .fade:not(.show){
            opacity: 1 !important;
        }

</style>
<!-- /.row -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Unit Actions</h3><br>
        <p>Total: {{count($activities)}}</p>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('units-history-export') ? 'example1' : 'nonExport' }} 
            class="table table-bordered ">
            <thead>
                <tr>
                    <th>Log</th>
                    <th>Event</th>

                    <th>Causer</th>
                    <th>Description</th>
                    <!-- <th>Old Data</th>
                    <th>New Data</th> -->

                    <th>Created Date</th>
                    <th>Created Time</th>
                </tr>
            </thead>
            <tbody>

                @foreach ($activities as $activity)
                <?php $temp = explode(' ',$activity->created_at->setTimezone('Africa/Cairo'));?>


                <tr data-toggle="modal" data-target={{$activity->event == 'updated' ? '#'."$activity->id": ''}}
                    class="modalData">
                    <td> {{$activity->log_name}} </td>
                    <td> {{$activity->event}} </td>
                    <td> {{$activity->causer_type::find($activity->causer_id)->name;}} </td>
                    <td> {{$activity->description}} </td>

                    <td>{{$temp[0] ?? ''}}</td>
                    <td>{{$temp[1] ?? ''}}</td>
                    <!-- <td>{{$temp[1] ?? ''}}</td>
                    <td>{{$temp[1] ?? ''}}</td> -->
                </tr>

                <!-- Delete Modal -->

                <div class="modal fade" id={{$activity->id}} tabindex="-1" role="dialog" aria-labelledby="myModal"
                    aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Log Details</h5>
                                <!-- <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button> -->
                            </div>
                            <div class="modal-body">
                                <?php
                                    $properties =  json_decode($activity->properties, true);
                                    // print_r($properties);
                                ?>
                                @foreach($properties as $key => $value)
                                @foreach($value as $keyy=>$vall)

                                <div class="row">
                                    @if($key == 'old')
                                    Changed from
                                    <label class="col-3">{{$keyy}} </label>
                                    @if($keyy == 'finishing' || $keyy == 'view' || $keyy == 'type')
                                    <label>
                                        ({{'App\Models\UnitSetting'::find($vall)->name ?? ''}})
                                    </label>
                                    @else
                                    <label>
                                        ({{$vall}})
                                    </label>
                                    @endif
                                    @else
                                    To
                                    <label class="col-3"> {{$keyy}}</label>
                                    @if($keyy == 'finishing' || $keyy == 'view' || $keyy == 'type')
                                    <label>
                                        ({{'App\Models\UnitSetting'::find($vall)->name ?? ''}})
                                    </label>
                                    @elseif($keyy == 'client_id')
                                    <label>
                                        ({{'App\Models\Client'::find($vall)?->name ?? ''}})
                                    </label>
                                    @else
                                    <label>
                                        ({{$vall ?? ''}})
                                    </label>
                                    @endif
                                    @endif
                                </div>

                                @endforeach
                                <hr>
                                @endforeach
                            </div>

                        </div>
                    </div>
                </div>

                @endforeach
            </tbody>
        </table>
    </div>
    <!-- /.card-body -->
</div>




@endsection