@extends ('../welcome')


@section('content')
    <?php
    $pagename = 'Users';
    ?>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">
                    <strong>BlockList</strong>
                    <br>
                    <lable><span style="font-size:18px;font-weight:bold">Total: </span> {{ count($users) }}</lable>
                    </h3>
            </div>
            <div class="card-body table-responsive p-0" style="height: 300px;">
                <table class="table table-head-fixed text-nowrap">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone Numbers</th>
                            <th>User Role</th>
                            <th>leader</th>
                            <th>Control</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $user)
                            <?php $temp = explode(' ', $user->created_at); ?>

                            <tr>
                                <td>{{ $user->id }}</td>
                                <td>
                                    <a href="{{ route('users.show', $user->id) }}">
                                        {{ $user->name }}
                                    </a>
                                </td>
                                <td>{{ $user->email }}</td>
                                <td>
                                    @foreach ($user->phones as $phone)
                                        <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                            {{ $phone->country->phonecode }}-{{ $phone->phone }}
                                        </a>
                                        <br>
                                    @endforeach
                                </td>
                                <td>{{ $user->role?->name ?? '' }}</td>
                                <td>{{ $user->leader?->name ?? '' }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-restore'))
                                        <a class="btn btn-success" title="unBlock" href="{{ route('unblock', $user->id) }}">
                                            <i class="fa fa-unlock"></i>
                                        </a>
                                    @endif
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-delete'))
                                        <a href="{{ route('users.destroy', $user->id) }}">
                                            <button title="Delete" class="btn btn-danger">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
