<?php
use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use Diglactic\Breadcrumbs\Breadcrumbs;
use Diglactic\Breadcrumbs\Generator as BreadcrumbTrail;

Breadcrumbs::for('dashboard', function (BreadcrumbTrail $trail): void {
    $trail->push('Dashboard', route('dashboard'));
});
//============================= Users/Profile ============================
Breadcrumbs::for('users.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Users', route('users.index'));
});
Breadcrumbs::for('blocklist', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('blocklist', route('blocklist'));
});
Breadcrumbs::for('usersTree', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('usersTree', route('usersTree'));
});
Breadcrumbs::for('users.edit', function (BreadcrumbTrail $trail , User $user): void {
    $trail->parent('users.index');
    $trail->push('Edit User', route('users.edit', $user));
});

Breadcrumbs::for('users.show', function (BreadcrumbTrail $trail , User $user): void {
    $trail->parent('users.index');
    $trail->push('edit user', route('users.show', $user));
});

Breadcrumbs::for('addUser', function (BreadcrumbTrail $trail): void {
    $trail->parent('users.index');
    $trail->push('Add User', route('addUser'));
});

Breadcrumbs::for('profile', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Profile', route('profile'));
});

Breadcrumbs::for('editProfile', function (BreadcrumbTrail $trail , $profileID): void {
    $trail->parent('profile');
    $trail->push('Edit Profile', route('editProfile', $profileID));
});
//============ ROLES =======================
Breadcrumbs::for('index.roles', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Roles', route('index.roles'));
});

Breadcrumbs::for('roles.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('index.roles');
    $trail->push('Create Role', route('roles.create'));
});

Breadcrumbs::for('roles.show', function (BreadcrumbTrail $trail , $roleId): void {
    $trail->parent('index.roles');
    $trail->push('Show Role', route('roles.show', $roleId));
});

Breadcrumbs::for('roles.edit', function (BreadcrumbTrail $trail , $roleId): void {
    $trail->parent('index.roles');
    $trail->push('Edit Role', route('roles.edit', $roleId));
});

//============ Permissions =======================

Breadcrumbs::for('index.permissions', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Permissions', route('index.permissions'));
});

Breadcrumbs::for('permissions.show', function (BreadcrumbTrail $trail , $permissionId): void {
    $trail->parent('index.permissions');
    $trail->push('Show Permissions', route('permissions.show', $permissionId));
});

//===================== Inquiries ================================
Breadcrumbs::for('inquiries.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Broker Request', route('inquiries.index'));
});

Breadcrumbs::for('inquiries.show', function (BreadcrumbTrail $trail , $inquiryId): void {
    $trail->parent('inquiries.index');
    $trail->push('Show inquiry', route('inquiries.show', $inquiryId));
});

//===================== inqTypes ================================

Breadcrumbs::for('inqTypes.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Create Request type', route('inqTypes.create'));
});


//===================== Clients ================================
Breadcrumbs::for('clients.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('clients', route('clients.index'));
});

Breadcrumbs::for('clients.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('clients.index');
    $trail->push('Create Client', route('clients.create'));
});

Breadcrumbs::for('clients.show', function (BreadcrumbTrail $trail , $clientId): void {
    $trail->parent('clients.index');
    $trail->push('', route('clients.show', $clientId));
});

Breadcrumbs::for('Reservation.form', function (BreadcrumbTrail $trail , $id): void {
    $trail->parent('clients.show', $id);
    $trail->push('Reservation form', route('Reservation.form', $id));
});

Breadcrumbs::for('clients.edit', function (BreadcrumbTrail $trail , $clientId): void {
    $trail->parent('clients.index');
    $trail->push('Edit Client', route('clients.edit', $clientId));
});

Breadcrumbs::for('toLead', function (BreadcrumbTrail $trail , $clientId): void {
    $trail->parent('clients.index');
    $trail->push('Edit Client', route('toLead', $clientId));
});

Breadcrumbs::for('clients.contract', function (BreadcrumbTrail $trail , $roleId): void {
    $trail->parent('clients.index');
    $trail->push('Contract', route('clients.contract', $roleId));
});

Breadcrumbs::for('UnitBatches', function (BreadcrumbTrail $trail , $unitId): void {
    $trail->parent('clients.index');
    $trail->push('Batches', route('UnitBatches', $unitId));
});

Breadcrumbs::for('reservationContract', function (BreadcrumbTrail $trail): void {
    $trail->parent('clients.index');
    $trail->push('Reservation Contract', route('reservationContract'));
});

Breadcrumbs::for('unitsHistory', function (BreadcrumbTrail $trail , $unitId): void {
    $trail->parent('units.index');
    $trail->push('actions history', route('unitsHistory', $unitId));
});

Breadcrumbs::for('hiddenUnits', function (BreadcrumbTrail $trail): void {
    $trail->parent('units.index');
    $trail->push('Hidden Units', route('hiddenUnits'));
});

Breadcrumbs::for('clients.archive', function (BreadcrumbTrail $trail): void {
    $trail->parent('clients.index');
    $trail->push('Archive', route('clients.archive'));
});

//============ Leads =======================

Breadcrumbs::for('leads.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Leads', route('leads.index'));
});

Breadcrumbs::for('Roles_Archive', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Roles Archive', route('Roles_Archive'));
});

Breadcrumbs::for('rolesTree', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Roles Tree', route('rolesTree'));
});

Breadcrumbs::for('leads.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('leads.index');
    $trail->push('Create Lead', route('leads.create'));
});

Breadcrumbs::for('leads.edit', function (BreadcrumbTrail $trail , $leadId): void {
    $trail->parent('leads.index');
    $trail->push('Edit Lead', route('leads.edit', $leadId));
});

Breadcrumbs::for('leads.show', function (BreadcrumbTrail $trail , $leadId): void {
    $trail->parent('leads.index');
    $trail->push('Show Lead', route('leads.show', $leadId));
});

Breadcrumbs::for('leads.importView', function (BreadcrumbTrail $trail): void {
    $trail->parent('leads.index');
    $trail->push('Import Lead', route('leads.importView'));
});

Breadcrumbs::for('leads.archive', function (BreadcrumbTrail $trail): void {
    $trail->parent('leads.index');
    $trail->push('Archive Leads', route('leads.archive'));
});

Breadcrumbs::for('delayLeads', function (BreadcrumbTrail $trail): void {
    $trail->parent('leads.index');
    $trail->push('Delay Leads', route('delayLeads'));
});

Breadcrumbs::for('statuses.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Lead Statuses', route('statuses.create'));
});

Breadcrumbs::for('CILs', function (BreadcrumbTrail $trail): void {
    $trail->parent('brokers.index');
    $trail->push('CILs', route('CILs'));
});

Breadcrumbs::for('activityManagment', function (BreadcrumbTrail $trail): void {
    $trail->parent('brokers.index');
    $trail->push('Activity Management', route('activityManagment'));
});
//============ Communications =======================
Breadcrumbs::for('communications.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Events', route('communications.index'));
});

Breadcrumbs::for('communications.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('communications.index');
    $trail->push('Create Event', route('communications.create'));
});

Breadcrumbs::for('nextActions', function (BreadcrumbTrail $trail): void {
    $trail->parent('communications.index');
    $trail->push('Actions taking place', route('nextActions'));
});

Breadcrumbs::for('communications.show', function (BreadcrumbTrail $trail, $communicationId): void {
    $trail->parent('dashboard');
    $trail->push('Show Event', route('communications.show',$communicationId));
});

Breadcrumbs::for('myActions', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Show Actions', route('myActions'));
});

// ===================== show trashed ===================
Breadcrumbs::for('showTrashed', function (BreadcrumbTrail $trail, $showTrashedId): void {
    $trail->parent('dashboard');
    $trail->push('Archived Client', route('showTrashed', $showTrashedId));
});

//====================== Payment =========================

// Breadcrumbs::for('payment.index', function (BreadcrumbTrail $trail): void {
//     $trail->parent('dashboard');
//     $trail->push('New Confirmed Clients', route('payment.index'));
// });
// Breadcrumbs::for('newClients', function (BreadcrumbTrail $trail): void {
//     $trail->parent('dashboard');
//     $trail->push('New Clients', route('newClients'));
// });



// Breadcrumbs::for('PaymentsOfClient', function (BreadcrumbTrail $trail, $id): void {
//     $trail->parent('newClients');
//     $trail->push('Payment Of Client', route('PaymentsOfClient' , $id));
// });

// Breadcrumbs::for('transactions.create', function (BreadcrumbTrail $trail): void {
//     $trail->parent('dashboard');
//     $trail->push('Create Clients transactions', route('transactions.create'));
// });

// Breadcrumbs::for('payment.show', function (BreadcrumbTrail $trail, $paymentId): void {
//     $trail->parent('newClients');
//     $trail->push('Payment Details', route('payment.show', $paymentId));
// });

// Tickets
Breadcrumbs::for('tickets.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Tickets', route('tickets.index'));
});

Breadcrumbs::for('delayTickets', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Delay Tickets', route('delayTickets'));
});

Breadcrumbs::for('actions.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Ticket Actions', route('actions.index'));
});

Breadcrumbs::for('tickets.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('tickets.index');
    $trail->push('New Ticket', route('tickets.create'));
});

Breadcrumbs::for('tickets.show', function (BreadcrumbTrail $trail , $id): void {
    $trail->parent('tickets.index');
    $trail->push('View Ticket', route('tickets.show' , $id));
});

Breadcrumbs::for('tickets.edit', function (BreadcrumbTrail $trail , $id): void {
    $trail->parent('tickets.index');
    $trail->push('Assign User', route('tickets.edit' , $id));
});


//============ Campaigns =======================

Breadcrumbs::for('campaigns.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Campaigns', route('campaigns.index'));
});

Breadcrumbs::for('campaigns.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('campaigns.index');
    $trail->push('Create Campaign', route('campaigns.create'));
});

Breadcrumbs::for('campaigns.edit', function (BreadcrumbTrail $trail , $leadId): void {
    $trail->parent('campaigns.index');
    $trail->push('Edit Campaign', route('campaigns.edit', $leadId));
});

Breadcrumbs::for('campaigns.show', function (BreadcrumbTrail $trail , $leadId): void {
    $trail->parent('campaigns.index');
    $trail->push('Show Campaign', route('campaigns.show', $leadId));
});

//============ sources =======================

Breadcrumbs::for('sources.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('sources', route('sources.index'));
});

Breadcrumbs::for('sources.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('sources.index');
    $trail->push('Create Source', route('sources.create'));
});

Breadcrumbs::for('sources.edit', function (BreadcrumbTrail $trail , $leadId): void {
    $trail->parent('sources.index');
    $trail->push('Edit Source', route('sources.edit', $leadId));
});

Breadcrumbs::for('sources.show', function (BreadcrumbTrail $trail , $leadId): void {
    $trail->parent('sources.index');
    $trail->push('Show Source', route('sources.show', $leadId));
});


//========================Projects================================

Breadcrumbs::for('projects.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Projects', route('projects.index'));
});

Breadcrumbs::for('projects.archive', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Project Archive', route('projects.archive'));
});

Breadcrumbs::for('projects.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('projects.index');
    $trail->push('Create Projects', route('projects.create'));
});

Breadcrumbs::for('projects.edit', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('projects.index');
    $trail->push('Update Project', route('projects.edit', $id));
});

Breadcrumbs::for('projects.show', function (BreadcrumbTrail $trail, $Projectid): void {
    $trail->parent('projects.index');
    $trail->push($Projectid->name. ' Project', route('projects.show', $Projectid));
});

//======================Phase=================================

Breadcrumbs::for('phases.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Phases', route('phases.index'));
});

Breadcrumbs::for('phases.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('projects.index');
    $trail->push('Create New Phase', route('phases.create'));
});

Breadcrumbs::for('phases.edit', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('projects.show', $id->project);
    $trail->push('Update Phase ' . $id->name , route('phases.edit', $id));
});

Breadcrumbs::for('phases.show', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('projects.show', $id->project);
    $trail->push($id->name ." Phase", route('phases.show', $id));
});

Breadcrumbs::for('phasesArchive', function (BreadcrumbTrail $trail): void {
    $trail->parent('phases.index');
    $trail->push('Phase Archive', route('phasesArchive'));
});

//======================== Building ==========================

Breadcrumbs::for('buildings.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Buildings', route('buildings.index'));
});

Breadcrumbs::for('buildings.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Create New Building', route('buildings.create'));
});

Breadcrumbs::for('buildings.edit', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('phases.show', $id->phase);
    $trail->push('Update Building '. $id->name, route('buildings.edit', $id));
});

Breadcrumbs::for('buildings.show', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('phases.show', $id->phase);
    $trail->push('Building ' . $id->name, route('buildings.show', $id));
});

Breadcrumbs::for('buildingsArchive', function (BreadcrumbTrail $trail): void {
    $trail->parent('buildings.index');
    $trail->push('Building Archive', route('buildingsArchive'));
});

// ===================Unit Settings =============================

Breadcrumbs::for('unitSettings.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Settings', route('unitSettings.index'));
});

Breadcrumbs::for('unitSettings.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('unitSettings.index');
    $trail->push('Manage unitSettings', route('unitSettings.create'));
});
Breadcrumbs::for('facilities.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('unitSettings.index');
    $trail->push('Manage Facilities', route('facilities.create'));
});

Breadcrumbs::for('ticket-types.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('unitSettings.index');
    $trail->push('Manage Ticket Types', route('ticket-types.create'));
});

Breadcrumbs::for('paymentTypes.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('unitSettings.index');
    $trail->push('Manage Payment Types', route('paymentTypes.create'));
});

Breadcrumbs::for('sourceTypes.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('campaigns.index');
    $trail->push('Manage Source Types', route('sourceTypes.create'));
});
// ===================Units =============================

Breadcrumbs::for('units.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('All Units', route('units.index'));
});

Breadcrumbs::for('units.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Manage units', route('units.create'));
});

Breadcrumbs::for('units.show', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('buildings.show', $id->building);
    $trail->push($id->name. ' Data' , route('units.show', $id));
});

Breadcrumbs::for('units.edit', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('buildings.show', $id->building);
    $trail->push($id->name . 'Details', route('units.edit', $id));
});

Breadcrumbs::for('units.importView', function (BreadcrumbTrail $trail): void {
    $trail->parent('units.index');
    $trail->push('Import Unit', route('units.importView'));
});

Breadcrumbs::for('unitsArchive', function (BreadcrumbTrail $trail): void {
    $trail->parent('units.index');
    $trail->push('Unit Archive', route('unitsArchive'));
});

//============== Calender ==================
Breadcrumbs::for('calendar.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Calendar', route('calendar.index'));
});

Breadcrumbs::for('listMeeting', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Meetings', route('listMeeting'));
});


 Breadcrumbs::for('payments.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Create Unit Payment', route('payments.create'));
});

// Notification Settings

Breadcrumbs::for('notifications.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('unitSettings.index');
    $trail->push('Manage notifications', route('notifications.create'));
});

//Activity Log

Breadcrumbs::for('logsActivities.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Activity Logs', route('logsActivities.index'));
});

// Reports 
Breadcrumbs::for('reports.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('', route('reports.index'));
});

Breadcrumbs::for('userLeads', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('user leads', route('userLeads'));
});

Breadcrumbs::for('ProjectCampagins', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('Project Campaigns', route('ProjectCampagins'));
});

Breadcrumbs::for('CampaignLeads', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('Campaign Leads', route('CampaignLeads'));
});

Breadcrumbs::for('userSales', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('Sales Units', route('userSales'));
});

Breadcrumbs::for('userActions', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('User Actions', route('userActions'));
});

Breadcrumbs::for('ProjectIncome', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('Project Income', route('ProjectIncome'));
});

Breadcrumbs::for('unitsReport', function (BreadcrumbTrail $trail): void {
    $trail->parent('reports.index');
    $trail->push('Units', route('unitsReport'));
});

//============ Contracts =======================

Breadcrumbs::for('contracts.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('contracts', route('contracts.index'));
});

Breadcrumbs::for('contracts.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('contracts.index');
    $trail->push('Create Contract', route('contracts.create'));
});

Breadcrumbs::for('contracts.edit', function (BreadcrumbTrail $trail , $id): void {
    $trail->parent('contracts.index');
    $trail->push('Edit Contract', route('contracts.edit', $id));
});

Breadcrumbs::for('contracts.show', function (BreadcrumbTrail $trail , $id): void {
    $trail->parent('contracts.index');
    $trail->push('Show Contract', route('contracts.show', $id));
});


Breadcrumbs::for('unitContract', function (BreadcrumbTrail $trail , $unitId, $clientId): void {
    $trail->parent('contracts.index');
    $trail->push('Contract', route('unitContract', [$unitId,$clientId]));
});

// Alerts

Breadcrumbs::for('alerts.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Notifications', route('alerts.index'));
});

Breadcrumbs::for('ClientContracts', function (BreadcrumbTrail $trail): void {
    $trail->parent('contracts.index');
    $trail->push('Client Contracts', route('ClientContracts'));
});

Breadcrumbs::for('cContractsArchive', function (BreadcrumbTrail $trail): void {
    $trail->parent('ClientContracts');
    $trail->push('Client Contracts Archive', route('cContractsArchive'));
});

Breadcrumbs::for('codes.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('contracts.index');
    $trail->push('Contract Codes', route('codes.index'));
});

//======================Payment Plans=================================

Breadcrumbs::for('paymentPlans.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Payment Plans', route('paymentPlans.index'));
});

Breadcrumbs::for('paymentPlans.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('paymentPlans.index');
    $trail->push('Create New Plan', route('paymentPlans.create'));
});

Breadcrumbs::for('paymentPlans.edit', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('paymentPlans.index');
    $trail->push($id->name , route('paymentPlans.edit', $id));
});

Breadcrumbs::for('paymentPlans.show', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('paymentPlans.index');
    $trail->push($id->name, route('paymentPlans.show', $id));
});


//======================Batches=================================

Breadcrumbs::for('batches.index', function (BreadcrumbTrail $trail, $unitId): void {
    $trail->parent('dashboard');
    $trail->push('batches', route('batches.index', $unitId));
});

Breadcrumbs::for('batches.create', function (BreadcrumbTrail $trail, $unitId): void {
    $trail->parent('batches.index', $unitId);
    $trail->push('Create New batch', route('batches.create', $unitId));
});

Breadcrumbs::for('batches.edit', function (BreadcrumbTrail $trail, $id): void {
    $unitId = $id->unit->id;
    $trail->parent('batches.index', $unitId);
    $trail->push('Edit Batch' , route('batches.edit', $id));
});

//======================phones=================================

Breadcrumbs::for('phones.edit', function (BreadcrumbTrail $trail , $id): void {
    $trail->parent('dashboard');
    $trail->push('Edit Phone number', route('phones.edit' , $id));
});


//======================Call Actions=================================

Breadcrumbs::for('callActions.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('CallActions', route('callActions.create'));
});


//======================Broker=================================

Breadcrumbs::for('brokers.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Brokers', route('brokers.index'));
});

Breadcrumbs::for('brokers.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('brokers.index');
    $trail->push('Create Broker', route('brokers.create'));
});

Breadcrumbs::for('brokers.show', function (BreadcrumbTrail $trail , $brokerId): void {
    $trail->parent('brokers.index');
    $trail->push('Show Broker', route('brokers.show', $brokerId));
});

Breadcrumbs::for('brokers.edit', function (BreadcrumbTrail $trail , $brokerId): void {
    $trail->parent('brokers.index');
    $trail->push('Edit Broker', route('brokers.edit', $brokerId));
});

Breadcrumbs::for('brokersArchive', function (BreadcrumbTrail $trail): void {
    $trail->parent('brokers.index');
    $trail->push('Broker Archive', route('brokersArchive'));
});


//======================Agent=================================

Breadcrumbs::for('agents.index', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('agents', route('agents.index'));
});

Breadcrumbs::for('agents.create', function (BreadcrumbTrail $trail): void {
    $trail->parent('dashboard');
    $trail->push('Create New agent', route('agents.create'));
});

Breadcrumbs::for('agents.edit', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('agents.show', $id);
    $trail->push('Edit Agent' , route('agents.edit', $id));
});

Breadcrumbs::for('agents.show', function (BreadcrumbTrail $trail, $id): void {
    $trail->parent('agents.index');
    $trail->push('Edit'.$id->name.' Agent' , route('agents.show', $id));
});
// Breadcrumbs::for('agentsArchive', function (BreadcrumbTrail $trail): void {
//     $trail->parent('agents.index');
//     $trail->push('agent Archive', route('agentsArchive'));
// });