


<?php $__env->startSection('content'); ?>

    <div class="container">
        <form action="<?php echo e(route('units.store')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="row justify-content-between">
                <div class="card card-info col-5">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control" placeholder="Unit Name"
                                        required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <?php if($building->phase->project->is_residential == 1): ?>
                                <div class="col-md-6">
                                    <div class="form-group row">
                                        <label class="col-3">floor</label>
                                        <select name='floor' id="floor" class="form-control col-6"
                                            style="width: 100%;">
                                            <option value="0">G</option>
                                            <?php for($i = 1; $i <= $building->number_of_floors; $i++): ?>
                                                <option value="<?php echo e($i); ?>"><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="floor" value="0">
                            <?php endif; ?>

                        </div>

                        <div class="row">
                            <div class="form-group col-5">
                                <input type="checkbox" id="roof" name="has_roof" style="width:25px;height:25px;">
                                <label style="margin-left:10px;" for="roof">Has Roof ?</label>
                            </div>

                            <div class="form-group col-5">
                                <input type="checkbox" id="garden" name="has_garden" style="width:25px;height:25px;">
                                <label style="margin-left:10px;" for="garden">Has Garden ?</label>
                            </div>
                        </div>

                        <?php if($building->type != 'Administrative'): ?>
                            <!-- <h5 style="color:red; font-weight:bold;font-style: italic;">Garden and Out-Areas Only Available For Floor 1</h5> -->
                            <div class="row">
                                <div id="ground" style="display:none; margin-right: 15px;">
                                    <div class="form-group">
                                        <label><?php echo e($building->type == 'Residential' ? 'Garden Space' : 'Out-area Space '); ?></label>
                                        <input type="number" step="any" name="garden_space" class="form-control"
                                            placeholder="00">
                                    </div>
                                </div>
                                <div id="roof-space" style="display:none; margin-right: 15px;">
                                    <div class="form-group">
                                        <label>Roof Space</label>
                                        <input type="number" step="any" name="roof_space" class="form-control"
                                            placeholder="00">
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label>Unit Space</label>
                                        <input type="number" step="any" name="unit_space" class="form-control"
                                            placeholder="00" required>
                                    </div>
                                </div>

                            </div>
                        <?php endif; ?>

                        <div class="row">
                            <input type="hidden" step="any" name="basement_space" value="0" class="form-control"
                                placeholder="Basement Space">
                        </div>

                        <?php if($building->type == 'Residential' || 'Multiple'): ?>
                            <?php if($building->phase->project->is_residential == 1): ?>
                                <div class="row">
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>BedRooms</label>
                                            <input type="number" name="bedrooms" class="form-control" placeholder="0">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>BathRooms</label>
                                            <input type="number" name="bathrooms" class="form-control" placeholder="0">
                                        </div>
                                    </div>
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <label>Dressing</label>
                                            <input type="number" name="dressing" class="form-control" placeholder="0">
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label>Description</label>
                                        <textarea name="description" id="description" cols="30" rows="4" class="form-control"
                                            placeholder="Description"></textarea>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <input class="form-check-input" name="is_active" value="1" type="hidden">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>View</label>
                                    <select name='view' class="form-control select2" style="width: 100%;">
                                        <?php $__currentLoopData = $views; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $view): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($view->id); ?>"><?php echo e($view->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Type</label>
                                    <select name='type' class="form-control select2" style="width: 100%;">
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Finishing</label>
                                    <select name='finishing' class="form-control select2" style="width: 100%;">
                                        <?php $__currentLoopData = $finishings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finishing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($finishing->id); ?>"><?php echo e($finishing->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <input type="hidden" name="building_id" value="<?php echo e($_GET['id']); ?>">
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card card-info col-5">
                    <div class="card-body">

                        
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Unit Meter Price for cash</label>
                                    <input type="number" step="any" name="unit_meter_price" class="form-control"
                                        value="0" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div id="inputContainer">
                                <div class="row inputRow">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Unit Meter Price</label>
                                            <input type="number" step="any" name="meter_price[]"
                                                class="form-control" value="0" required>
                                        </div>
                                    </div>

                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <label>Number of Years</label>
                                            <input type="number" name="years[]" class="form-control" value="1"
                                                required>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Add Another Button -->
                            <div class="col-sm-2">
                                <div class="form-group">
                                    <label>&nbsp;</label> <!-- Creates space for alignment -->
                                    <button type="button" id="addRow" class="btn btn-success form-control">+</button>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>


            </div>
            <div class="container" style="text-align: end">
                <button type="submit" class="btn btn-info">Submit</button>
            </div>
        </form>
    </div>




    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#floor').on('change', () => {
                let floor = $('#floor option:selected').text();
                if (floor == 'G') {
                    $("#ground").show();
                } else {
                    $("#ground").hide();
                }
            });

            $('input[type="checkbox"]#roof').click(function() {
                if ($(this).prop("checked") == true) {
                    $("#roof-space").show();
                } else {
                    $("#roof-space").hide();

                }
            });

            $('input[type="checkbox"]#garden').click(function() {
                if ($(this).prop("checked") == true) {
                    $("#ground").show();
                } else {
                    $("#ground").hide();

                }
            });

        });


        $(document).ready(function() {
            // Add new input row when "+" button is clicked
            $('#addRow').click(function() {
                // Create new row with inputs
                var newRow = `
            <div class="row inputRow" style="align-items: center;">
                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Unit Meter Price</label>
                        <input type="number" step="any" name="meter_price[]" class="form-control" value="0" required>
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="form-group">
                        <label>Number of Years</label>
                        <input type="number" name="years[]" class="form-control" value="1" required>
                    </div>
                </div>

                <!-- Remove Button for new rows -->
                <div class="col-sm-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="button" class="btn btn-danger removeRow">-</button>
                    </div>
                </div>
            </div>`;

                // Append new row to container
                $('#inputContainer').append(newRow);
            });

            // Remove input row when "-" button is clicked
            $(document).on('click', '.removeRow', function() {
                $(this).closest('.inputRow').remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/units/create.blade.php ENDPATH**/ ?>