
<?php $__env->startSection('content'); ?>
    <style>
        .clickable-row:hover {
            background-color: #17a2b8;
            opacity: 0.8;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }

        th {
            width: 40%;
        }
    </style>
    <div class="card col-6">
        <div class="card-header">

            <form action="<?php echo e(route('hidePhase', $phase->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>


                
                <a href="<?php echo e(route('phases.edit', $phase->id)); ?>">
                    <button class="btn btn-square btn-info" type="button"><i class="fa fa-pen"></i></button>
                </a>
                

                
                <button onClick="clickDeletebutton(this)" type="button" title="Delete" class="btn btn-danger"
                    data-id="<?php echo e($phase->id); ?>" data-toggle="modal" data-target="#phaseModal">
                    <i class="fa fa-ban"></i>
                </button>
                

                <button type="submit" style="float:right"
                    class="btn btn-<?php echo e($phase->is_active == 0 ? 'light' : 'dark'); ?> active"
                    title="<?php echo e($phase->is_active == 0 ? 'unhide' : 'hide'); ?>">
                    <i class="fas fa-<?php echo e($phase->is_active == 0 ? 'eye' : 'eye-slash'); ?>"></i>
                </button>

            </form>


        </div>
        <div class="card-body">
            <table>
                <tr>
                    <th>Phase Name:</th>
                    <td><?php echo e($phase->name); ?></td>
                </tr>
                <tr>
                    <th>Project Name:</th>
                    <td><?php echo e($phase->project->name); ?><?php echo e($phase->project->is_residential == 1 ? ' - Residential' : ''); ?></td>
                </tr>
                <?php if($phase->project->is_residential == 0): ?>
                    <tr>
                        <th>Type</th>
                        <td><?php echo e($phase->type ?? ''); ?></td>
                    </tr>
                <?php endif; ?>
                <tr>
                    <th>Active:</th>
                    <td><?php echo e($phase->is_active == 0 ? 'Not Available' : 'Available'); ?></td>
                </tr>
                <tr>
                    <th>Created at :</th>
                    <td><?php echo e($phase->created_at); ?></td>
                </tr>
                <?php if(auth()->user()->type == 'admin'): ?>
                <tr>
                    <th>Accessed By :</th>
                </tr>
                <?php $__currentLoopData = $phase->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th></th>
                        <td>
                            <a href="<?php echo e(route('users.show', $user->id)); ?>">
                                <?php echo e($user->name); ?>

                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </table>
        </div>
    </div>
    
    <div class="col-12">
        <div class="card card-outline card-info">
            <div class="card-header">
                <h3 class="card-title" style="font-weight:bold">
                    <?php echo e($phase->project->is_residential == 1 ? 'building' : 'Floor'); ?>

                    <p>Total: <?php echo e(count($phase->buildings)); ?></p>
                </h3>

                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('buildings-create')): ?>
                    <a href="<?php echo e(route('buildings.create', 'id=' . $phase->id)); ?>">
                        <button class="btn btn-square btn-light active"
                            title="<?php echo e($phase->project->is_residential == 1 ? 'Create Building' : 'Create Floor'); ?>"
                            style="float:right" type="button"><i class="fas fa-plus"></i></button>
                    </a>
                <?php endif; ?>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table
                    id=<?php echo e(auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('buildings-export')? 'example1': 'nonExport'); ?>

                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>

                            <?php if($phase->project->is_residential == 1): ?>
                                <th>Building Type</th>
                                <th>Number of Floors</th>
                            <?php endif; ?>

                            <th>Created Date</th>
                            <th>Created Time</th>

                            <?php if(auth()->user()->type == 'admin'): ?>
                                <th>Visibility</th>
                            <?php endif; ?>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $phase->buildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $building->created_at->setTimezone('Africa/Cairo')); ?>
                            <?php if(auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('buildings-show')): ?>
                                <tr class='clickable-row' data-href='<?php echo e(route('buildings.show', $building->id)); ?>'>
                                <?php else: ?>
                                <tr>
                            <?php endif; ?>
                            <td><?php echo e($building->id); ?></td>
                            <td><?php echo e($building->name); ?></td>

                            <?php if($building->phase->project->is_residential == 1): ?>
                                <td><?php echo e($building->type); ?></td>
                                <td><?php echo e($building->number_of_floors); ?></td>
                            <?php endif; ?>
                            <td><?php echo e($temp[0]); ?></td>
                            <td><?php echo e($temp[1]); ?></td>
                            <td>
                                <?php if(auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('buildings-hide')): ?>
                                    <form action="<?php echo e(route('hideBuilding', $building->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php if(auth()->user()->type == 'admin'): ?>
                                            <button type="submit"
                                                class="btn btn-<?php echo e($building->is_active == 0 ? 'light' : 'dark'); ?>"
                                                title="<?php echo e($building->is_active == 0 ? 'unhide' : 'hide'); ?>">
                                                <i
                                                    class="fas fa-<?php echo e($building->is_active == 0 ? 'eye' : 'eye-slash'); ?>"></i>
                                            </button>
                                        <?php endif; ?>
                                    </form>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if(auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('buildings-edit')): ?>
                                    <a class="btn btn-info" title="Edit"
                                        href="<?php echo e(route('buildings.edit', $building->id)); ?>">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th></th>

                            <?php if($phase->project->is_residential == 1): ?>
                                <th></th>
                                <th></th>
                            <?php endif; ?>

                            <th></th>
                            <th></th>

                            <?php if(auth()->user()->type == 'admin'): ?>
                                <th></th>
                            <?php endif; ?>
                            <th></th>
                        </tr>
                    </tfoot>
                </table>

            </div>
        </div>
    </div>
    
    <div class="modal fade" id="phaseModal" tabindex="-1" role="dialog" aria-labelledby="phaseModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <?php if(count($phase->buildings) == 0): ?>
                        <p>Are you sure to delete this record ?</p>
                    <?php else: ?>
                        <p>this Phase has Buildings you can't delete this Phase</p>
                    <?php endif; ?>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <?php if(count($phase->buildings) == 0): ?>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>



    <!-- /.row -->
    <script>
        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.location = $(this).data("href");
            });
        });

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('phases.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#phaseModal').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/phases/show.blade.php ENDPATH**/ ?>