
<?php $__env->startSection('content'); ?>
    <style>
        h5 {
            font-weight: bold;
            font-size: 20px;
            padding-right: 15px;
        }

        span {
            font-weight: 90px;
            font-size: 20px;
        }

        .callout a {
            text-decoration: none !important;
        }

        .callout a:hover {
            color: #17a2b8;
            font-weight: bold;
        }

        .custom-select {
            /* width: none; */
        }

        .btns {
            font-size: 15px !important;
        }

        th {
            width: 30%
        }
    </style>

    <div class="card callout callout-info col-5">
        <div class="card-header">
            <h3 class="card-title">
                <span>Action Details</span>
            </h3>
        </div>
        <?php if($communication->broker_id == null): ?>
            <div class="card-body">
                <table>
                    <tbody>
                        <tr>
                            <th>Lead Name:</th>
                            <td>
                                <?php if(auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('leads-show')): ?>
                                    <a href="<?php echo e(route('leads.show', $communication->lead->id)); ?>">
                                        <?php echo e($communication->lead->name); ?>

                                    </a>
                                <?php else: ?>
                                    <a>
                                        <?php echo e($communication->lead->name); ?>

                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>User Name:</th>
                            <td>
                                <?php if(auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('users-show')): ?>
                                    <a href="<?php echo e(route('users.show', $communication->user->id)); ?>">
                                        <?php echo e($communication->user->name); ?>

                                    </a>
                                <?php else: ?>
                                    <a>
                                        <?php echo e($communication->user->name); ?>

                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <tr>
                            <th>Status</th>
                            <td class="text-<?php echo e($communication->CommunicationStatus?->color); ?>">
                                <?php echo e($communication->CommunicationStatus?->name); ?>

                            </td>
                        </tr>

                        <tr>
                            <th>Description</th>
                            <td><?php echo e($communication->description); ?></td>
                        </tr>

                        <tr>
                            <th>Title :</th>
                            <td style="font-weight:bold;color:#17a2b8;">
                                <?php echo e($communication->event?->title); ?>

                            </td>
                        </tr>

                        <tr>
                            <th>Date of Action :</th>
                            <?php
                                $date = strtotime($communication->event?->start);
                                $start = date('Y-m-d h:i:s', $date);
                            ?>
                            <td><?php echo e($start); ?></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                
                    
                
            </div>
        <?php else: ?>
            <div class="card-body">
                <table>
                    <tbody>
                        <tr>
                            <th>Type: </th>
                            <td><?php echo e($communication->type ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th>State: </th>
                            <td><?php echo e($communication->state ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th>Date: </th>
                            <td><?php echo e($communication->event->start ?? ''); ?></td>
                        </tr>
                        <tr>
                            <th>Broker: </th>
                            <td>
                                <a href="<?php echo e(route('brokers.show', $communication->broker->id)); ?>">
                                    <?php echo e($communication->broker?->name ?? ''); ?>

                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>Agent: </th>
                            <td>
                                <a href="<?php echo e(route('agents.show', $communication->agent_id)); ?>">
                                    <?php echo e($communication->agent->name ?? ''); ?>

                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>User: </th>
                            <td>
                                <a href="<?php echo e(route('users.show', $communication->user->id)); ?>">
                                    <?php echo e($communication->user->name ?? ''); ?>

                                </a>
                            </td>
                        </tr>
                        <tr>
                            <th>Description: </th>
                            <td><?php echo e($communication->description ?? ''); ?></td>
                        </tr>
                        <?php if($communication->check_in == 0): ?>
                            <tr>
                                <th>Reminder: </th>
                                <td><?php echo e($communication->reminder ?? '--'); ?></td>
                            </tr>
                        <?php else: ?>
                            <tr>
                                <th>Close: </th>
                                <td><?php echo e($communication->event->end ?? ''); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <div class="card-footer">
                <?php if($communication->check_in == 0): ?>
                    <table>
                        <tbody>
                            <tr>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-checkIn-activities')): ?>
                                        <button type="button" class="btn btn-success" title="checkIn" data-toggle="modal"
                                            data-target="#CheckIn">
                                            Check In
                                        </button>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-edit-activities')): ?>
                                        <button type="button" class="btn btn-info" title="edit activity"
                                            data-toggle="modal" data-target="#editActivity">
                                            Edit
                                        </button>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('brokers-reAssign-activities')): ?>
                                        <button type="button" class="btn btn-warning" title="Re-assign User"
                                            data-toggle="modal" data-target="#reAssignUser">
                                            Re-assign user
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="modal fade" id="editActivity" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Create Activity </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('communications.update', $communication->id)); ?>" method="POST">

                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <label for="type">Type: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="type" class="select2 custom-select form-control-border"
                                            id="type">
                                            <option value="call" <?php echo e($communication->type == 'call' ? 'selected' : ''); ?>>
                                                call
                                            </option>
                                            <option value="follow_up"
                                                <?php echo e($communication->type == 'follow_up' ? 'selected' : ''); ?>>follow up
                                            </option>
                                            <option value="site" <?php echo e($communication->type == 'site' ? 'selected' : ''); ?>>
                                                site
                                            </option>
                                            <option value="visit" <?php echo e($communication->type == 'visit' ? 'selected' : ''); ?>>
                                                Visit
                                            </option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="state">State: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="state" class="select2 custom-select form-control-border"
                                            id="state">
                                            <option value="todo" <?php echo e($communication->state == 'todo' ? 'selected' : ''); ?>>
                                                to do</option>
                                            <option value="in_progress"
                                                <?php echo e($communication->state == 'in_progress' ? 'selected' : ''); ?>>in
                                                progress
                                            </option>
                                            <option value="done" <?php echo e($communication->state == 'done' ? 'selected' : ''); ?>>
                                                done</option>
                                            <option value="cancel"
                                                <?php echo e($communication->state == 'cancel' ? 'selected' : ''); ?>>cancel
                                            </option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="broker">broker: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="hidden" name="broker_id" value="<?php echo e($broker?->id); ?>">
                                        <select name="broker_id" disabled class="custom-select form-control-border"
                                            id="broker">
                                            <option value="<?php echo e($broker?->id); ?>">
                                                <?php echo e($broker?->name); ?>

                                            </option>
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="agents">Agents: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="agent_id" class="select2 custom-select form-control-border"
                                            id="agents">
                                            <?php $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($agent->id); ?>"
                                                    <?php echo e($communication->agent_id == $agent->id ? 'selected' : ''); ?>>
                                                    <?php echo e($agent->name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="start">To Do: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="start"
                                            value="<?php echo e(date('Y-m-d H:i:s')); ?>" name="start_date"
                                            min="<?php echo e(date('Y-m-d H:i:s')); ?>"
                                            value="<?php echo e($communication->event->start ?? ''); ?>">
                                    </td>
                                </tr>
                                <tr id="reminderInput">
                                    <td>
                                        <label for="reminder">Reminder: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="reminder" name="reminder"
                                            min="<?php echo e(date('Y-m-d H:i:s')); ?>" value="<?php echo e($communication->reminder ?? ''); ?>">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description">
                                            <?php echo e($communication->description ?? ''); ?>

                                        </textarea>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="CheckIn" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Activity CheckIn</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('checkIn')); ?>" method="POST">

                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        
                        <input type="hidden" value="<?php echo e($communication->id); ?>" name="communication_id">
                        <table>
                            <tbody>

                                <tr>
                                    <td>
                                        <label for="start">To Do: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="start"
                                            name="start_date" value="<?php echo e($communication->event->start ?? ''); ?>">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="end">Close : </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="end" name="end_date"
                                            value="<?php echo e($communication->event->end ?? ''); ?>">
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description">
                                            <?php echo e($communication->description ?? ''); ?>

                                        </textarea>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Check in</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="reAssignUser" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Re-Assign User</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="<?php echo e(route('activityReAssign')); ?>" method="POST">

                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        
                        <input type="hidden" value="<?php echo e($communication->id); ?>" name="communication_id">
                        <select name="user_id" class="select2 custom-select form-control-border" id="type">
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/communications/show.blade.php ENDPATH**/ ?>