


<?php $__env->startSection('content'); ?>
    <?php
    $pagename = 'Users';
    ?>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">
                    <strong>BlockList</strong>
                    <br>
                    <lable><span style="font-size:18px;font-weight:bold">Total: </span> <?php echo e(count($users)); ?></lable>
                    </h3>
            </div>
            <div class="card-body table-responsive p-0" style="height: 300px;">
                <table class="table table-head-fixed text-nowrap">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Phone Numbers</th>
                            <th>User Role</th>
                            <th>leader</th>
                            <th>Control</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $user->created_at); ?>

                            <tr>
                                <td><?php echo e($user->id); ?></td>
                                <td>
                                    <a href="<?php echo e(route('users.show', $user->id)); ?>">
                                        <?php echo e($user->name); ?>

                                    </a>
                                </td>
                                <td><?php echo e($user->email); ?></td>
                                <td>
                                    <?php $__currentLoopData = $user->phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <?php echo e($phone->phone); ?>

                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($user->role?->name ?? ''); ?></td>
                                <td><?php echo e($user->leader?->name ?? ''); ?></td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-restore')): ?>
                                        <a class="btn btn-success" title="unBlock" href="<?php echo e(route('unblock', $user->id)); ?>">
                                            <i class="fa fa-unlock"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-delete')): ?>
                                        <a href="<?php echo e(route('users.destroy', $user->id)); ?>">
                                            <button title="Delete" class="btn btn-danger">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/users/blocklist.blade.php ENDPATH**/ ?>