
<?php $__env->startSection('content'); ?>
    <div class="row">

        <div class="col-md-6">

            <div class="card">
                <div class="card-header">
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                            <!-- <i class="fas fa-minus"></i> -->
                        </button>
                    </div>
                    <h3 class="card-title">
                        <?php echo e($campaign->name); ?> Campaign Data
                    </h3>
                </div>
                <div class="card-body">
                    <dl class="row">
                        <dt class="col-sm-4">Name :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->name); ?></dd>
                    </dl>
                    <dl class="row">
                        <?php if(!empty($campaign->project->id)): ?>
                            <dt class="col-sm-4">Project :</dt>
                            <dd class="col-sm-8">
                                <a href="<?php echo e(route('projects.show', $campaign->project->id)); ?>">
                                    <?php echo e($campaign->project->name); ?> </a>
                            </dd>
                        <?php endif; ?>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Description :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->description); ?></dd>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Status :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->status); ?></dd>
                    </dl>

                    <dl class="row">
                        <dt class="col-sm-4">Start Date :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->start_date); ?></dd>
                    </dl>

                    <dl class="row">
                        <dt class="col-sm-4">End Date :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->end_date); ?></dd>
                    </dl>

                    <dl class="row">
                        <dt class="col-sm-4">Budget :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->budget); ?></dd>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Target :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->target ?? ''); ?></dd>
                    </dl>
                    <dl class="row">
                        <dt class="col-sm-4">Purpose :</dt>
                        <dd class="col-sm-8"><?php echo e($campaign->purpose ?? ''); ?></dd>
                    </dl>
                    
                    
                    <div style="margin-bottom:10px; float:right">
                        <?php if(auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('campaigns-edit')): ?>
                            <a class="btn btn-info" title="Edit" href="<?php echo e(route('campaigns.edit', $campaign->id)); ?>">
                                <i class="fa fa-pen"></i>
                            </a>
                        <?php endif; ?>

                        <?php if(auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('campaigns-delete')): ?>
                            <?php if(count($campaign->leads) == 0 && count($campaign->sources) == 0): ?>
                                <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                    data-id="<?php echo e($campaign->id); ?>" data-toggle="modal" data-target="#exampleModalCenter">
                                    <i class="fa fa-ban"></i>
                                </button>
                            <?php endif; ?>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
        <div class="col-6">
            <div class="card">
                <div class="card-header">
                    <div class="card-tools">
                        <button type="button" class="btn btn-tool" data-card-widget="collapse" title="Collapse">
                            <i class="fas fa-minus"></i>
                        </button>
                    </div>
                    <h3 class="card-title">
                        Leads
                    </h3>
                    <!-- <h5>Leads</h5> -->
                </div>
                <!-- /.card-header -->
                <div class="card-body">
                    <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('campaign-leads-export') ? 'leads' : 'nonExport'); ?> 
                        class="display table table-bordered table-striped">
                        <thead>
                            <tr>

                                <th>ID</th>
                                <th>Name</th>
                                <th>Status</th>
                                <th>Assigned User</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $campaign->leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($lead->id); ?></td>
                                    <td>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('leads-show')): ?>
                                            <a href="<?php echo e(route('leads.show', $lead->id)); ?>">
                                                <?php echo e($lead->name); ?>

                                            </a>
                                        <?php else: ?>
                                            <a>
                                                <?php echo e($lead->name); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($lead->status == 'converted' ? 'client' : $lead->status); ?></td>
                                    <td>
                                        <a>
                                            <?php echo e($lead->user->name ?? ''); ?>

                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>


    <script src="https://code.jquery.com/jquery-3.5.1.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('campaigns.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/campaigns/show.blade.php ENDPATH**/ ?>