


<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('clients.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="card">
            <div class="card-header">
                <p class="login-box-msg text-info" style="font-weight:bold">Create Client Profile</p>
            </div>
            <div class="card-body register-card-body">

                <div class="row">
                    <div class="col-6">
                        <!-- Left Side -->
                        <?php if(isset($lead)): ?>
                            <input type="hidden" value="<?php echo e($lead->id); ?>" name="leadId">
                        <?php endif; ?>
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Name</label>
                            <?php if(!empty($lead)): ?>
                                <input type="hidden" name="name" value="<?php echo e($lead->name); ?>">
                                <input type="text" readonly name="name" value="<?php echo e($lead->name); ?>"
                                    class="form-control">
                            <?php else: ?>
                                <input type="text" name="name" placeholder="Client Name" class="form-control">
                            <?php endif; ?>
                        </div>
                        <br>
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Email</label>
                            <?php if(isset($lead)): ?>
                                <input type="hidden" name="email" value="<?php echo e($lead->email); ?>">
                                <input type="email" readonly class="form-control" placeholder="email@example.com"
                                    value="<?php echo e($lead->email); ?>" name="email">
                            <?php else: ?>
                                <input type="email" class="form-control" placeholder="email@example.com" name="email">
                            <?php endif; ?>
                        </div>

                        <br>
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Job Title</label>
                            <?php if(isset($lead)): ?>
                                <input type="hidden" name="job_title" value="<?php echo e($lead->job_title); ?>">
                                <input type="text" readonly class="form-control" value="<?php echo e($lead->job_title); ?>"
                                    name="job_title">
                            <?php else: ?>
                                <input type="text" class="form-control" placeholder="ex: Developer" name="job_title">
                            <?php endif; ?>
                        </div>
                        <br>
                        
                        <div class="col-10 mb-3" style="display: inline-block;">
                            <label for="campaign_id">Campaign</label>
                            <input type="hidden" name="campaign_id" value="<?php echo e($lead->campaign_id ?? ''); ?>">
                            <input type="text" readonly class="form-control" value="<?php echo e($lead->campaign?->name); ?>">
                        </div>

                        <div class="col-10 mb-3" style="display: inline-block;">
                            <label for="source_id">Source</label>
                            <input type="hidden" name="source_id" value="<?php echo e($lead->source_id ?? ''); ?>">
                            <input type="text" readonly class="form-control" value="<?php echo e($lead->source?->name); ?>">
                        </div>
                        
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Came From</label>
                            <input type="text" class="form-control" value="<?php echo e($lead->came_from); ?>" name="came_from">
                        </div>
                        <br>

                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID Date<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_date">
                        </div>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID City<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_city">
                        </div>
                        <br>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID Number<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_number">
                        </div>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID Address<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_address">
                        </div>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Nationality<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="nationality">
                        </div>
                        <br>

                        <br>
                        <!-- End Left Side -->
                    </div>
                    <div class="col-6">
                        <!-- right Side -->
                        <div class="col-md-12">
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h3 class="card-title">Mobile Number</h3>

                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                    <!-- /.card-tools -->
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                                    <div id="inputFormRow" style="margin-left: 9px;">
                                        <div class="row">
                                            <div class="col-12" style="display: inline-block">
                                                <label></label>
                                                
                                                <?php if(isset($lead)): ?>
                                                    <?php $__currentLoopData = $lead->phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mobile): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div id="inputFormRow">
                                                            <div class="row">
                                                                <div class="col-4">
                                                                    <div class="form-group" style="margin-top:20px;">
                                                                        <input type="text" class="form-control m-input"
                                                                        value="<?php echo e($mobile->country->name); ?> +<?php echo e($mobile->country->phonecode); ?>" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-6" style="margin-top:20px;">
                                                                    <input type="text" class="form-control m-input"
                                                                        value="<?php echo e($mobile->phone); ?>" id="phone"
                                                                        placeholder="Phone Number" name="mobile_number[]"
                                                                        readonly>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php else: ?>
                                                    <div id="inputFormRow">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <div class="form-group" style="margin-top:20px;">
                                                                    <select name="country_id"
                                                                        class="select2 custom-select form-control-border"
                                                                        id="Country">
                                                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option value="<?php echo e($country->id); ?>">
                                                                                <?php echo e($country->name); ?>

                                                                                +<?php echo e($country->phonecode); ?>

                                                                            </option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-6" style="margin-top:20px;">
                                                                <input type="text" class="form-control m-input"
                                                                    placeholder="Phone Number" id="phone"
                                                                    name="mobile_number[]" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div id="newRow"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer" style="text-align:center;">
                <button type="submit" class="btn btn-info" style="width:200px;">Submit</button>
            </div>
        </div>
    </form>
    <!-- /.form-box -->
    </div>
    <script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row">
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                    <select name="country_id"
                        class="select2 custom-select form-control-border" id="Country">
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($country->id); ?>">
                            <?php echo e($country->name); ?> +<?php echo e($country->phonecode); ?>

                        </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" id="phone"
                    placeholder="Phone Number" name="mobile_number[]" required>
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });

        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script><!-- /.card -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/clients/create.blade.php ENDPATH**/ ?>