

<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('users.update', $user->id)); ?>" method="POST">
        <div class="card">
            <div class="row">
                <div class="col-6">
                    <div class="register-box">
                        <div class="card-body register-card-body">
                            <p class="login-box-msg">Add new membership</p>
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <!-- <input type="hidden" name="user_id" value="<?php echo e($user->id); ?>"> -->
                            <div class="input-group mb-3">
                                <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>"
                                    placeholder="Full name" required autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input type="email" class="form-control" placeholder="Email" value="<?php echo e($user->email); ?>"
                                    name="email" require>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-envelope"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">

                                <input type="password" id="password" class="form-control p-relative" placeholder="Password"
                                    name="password" require>

                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <img onclick="replaceImageName()" src="<?php echo e(asset('asset/images/close.png')); ?>"
                                            width="30px" height="30px" id="peekEmoji" alt=""
                                            style="position: absolute;
                                    z-index: 100;
                                    right: 10px;
                                    top: 5px;">
                                    </div>
                                </div>
                            </div>
                            <?php if(auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('users-assignRole')): ?>
                                <div class="form-group">
                                    <label for="userRole">Select User Role</label>
                                    <select name="role_id" class="select2 custom-select form-control-border" id="userRole">
                                        <option value="">--</option>
                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($role->id); ?>"
                                                <?php echo e($role->id == $user->role_id ? 'selected' : ''); ?>>
                                                <?php echo e($role->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            <?php endif; ?>

                            <?php if(auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('users-assignLeader')): ?>
                                <div class="form-group">
                                    <label for="users">Assign To</label>
                                    <select name="assigned_to" class="select2 custom-select form-control-border"
                                        id="users">
                                        <option value="">--</option>
                                        <option value="<?php echo e(auth()->user()->id); ?>"
                                            <?php echo e(auth()->user()->id == $user->assigned_to ? 'selected' : ''); ?>>
                                            <?php echo e(auth()->user()->name); ?></option>
                                        <?php for($i = 0; $i < count($UserChildren); $i++): ?>
                                            <option value="<?php echo e($UserChildren[$i]['id']); ?>"
                                                <?php echo e($UserChildren[$i]['id'] == $user->parent?->id ? 'selected' : ''); ?>>
                                                <?php echo e($UserChildren[$i]['name']); ?>

                                            </option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            <?php endif; ?>

                            <div class="col-6" style="float:right;">
                                <button type="submit" class="btn btn-info">Edit User Data</button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-6">
                    <div id="inputFormRow">
                        <?php $__empty_1 = true; $__currentLoopData = $user->phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div id="inputFormRow">
                                <div class="row card-body">
                                    <div class="col-4">
                                        <p class="login-box-msg">Country</p>

                                        <select name="country_id[]" class="select2 custom-select form-control-border"
                                            id="Country">
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country->id); ?>"
                                                    <?php echo e($country->id == $phone->country->id ? 'selected' : ''); ?>>
                                                    <?php echo e($country->name); ?>

                                                    +<?php echo e($country->phonecode); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-6">
                                        <p class="login-box-msg">phone number</p>
                                        <input type="text" class="form-control m-input" value="<?php echo e($phone->phone); ?>"
                                            placeholder="Phone Number" name="mobile_number[]" id="phone" required>
                                    </div>
                                    <div class="col-2" style="padding-top:43px;">
                                        <button id="removeRow" type="button" class="btn btn-danger">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div id="inputFormRow">
                                <div class="row">
                                    <div class="col-4">
                                        <p class="login-box-msg">Country</p>

                                        <select name="country_id[]" class="select2 custom-select form-control-border"
                                            id="Country">
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?>

                                                    +<?php echo e($country->phonecode); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="col-5">
                                        <p class="login-box-msg">phone number</p>
                                        <input type="text" class="form-control m-input" placeholder="Phone Number"
                                            name="mobile_number[]" id="phone" required>
                                    </div>
                                    <div class="col-3" style="padding-top:43px;">
                                        <div class="row" style="justify-content: space-between">
                                            <button id="removeRow" type="button" class="btn btn-danger mx-3 ">
                                                <i class="fas fa-trash-alt"></i>
                                            </button>
                                            <button id="addRow" type="button" class="btn btn-info">
                                            <i class="fas fa-plus"></i>
                                        </button>
                                    </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div id="newRow"></div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        function replaceImageName() {
            let peekEmoji = document.getElementById('peekEmoji');
            var imageName = peekEmoji.src.split("/").pop();
            let newImageName = peekEmoji.src
            let password = document.getElementById('password');

            if (password.type === 'password') {
                password.type = 'text'
            } else {
                password.type = 'password'
            }

            if (peekEmoji.src.endsWith('close.png')) {
                peekEmoji.src = peekEmoji.src.replace(imageName, 'peek.gif')
            } else if (peekEmoji.src.endsWith('peek.gif')) {
                peekEmoji.src = peekEmoji.src.replace(imageName, 'close.png')

            }
        }


        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="select2 custom-select form-control-border" id="Country">
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?> +<?php echo e($country->phonecode); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" value="<?php echo e(old('phone_number')); ?>"
                    placeholder="Phone Number"  id="phone" required name="mobile_number[]">
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });
        // remove row
        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/users/edit.blade.php ENDPATH**/ ?>