


<?php $__env->startSection('content'); ?>
    <form action="<?php echo e(route('storeUser')); ?>" method="POST">

        <div class="card">
            <div class="row">
                <div class="col-6">
                    <div class="register-box">
                        <div class="card-body register-card-body">
                            <p class="login-box-msg">Add new membership</p>
                            <?php echo csrf_field(); ?>
                            <div class="input-group mb-3">
                                <input type="text" name="name" class="form-control" placeholder="Full name" required
                                    autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input type="email" class="form-control" placeholder="Email" name="email" require>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-envelope"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input class="form-control" placeholder="Password" type="password" name="password" required
                                    autocomplete="new-password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input type="password" class="form-control" placeholder="Retype password" type="password"
                                    name="password_confirmation" required>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="userRole">Select User Role</label>
                                <select name="role_id" class="select2 custom-select form-control-border" id="userRole">
                                    <?php if(auth()->user()->type == 'admin'): ?>
                                        <?php $__currentLoopData = $RoleChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php for($i = 0; $i < count($RoleChildren); $i++): ?>
                                            <option value="<?php echo e($RoleChildren[$i]['id']); ?>"><?php echo e($RoleChildren[$i]['name']); ?>

                                            </option>
                                        <?php endfor; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="userTeams">Assign To leader</label>
                                <select name="assigned_to" class="select2 custom-select form-control-border" id="userTeams">
                                    <option value="">--</option>
                                    <?php if(auth()->user()->type == 'admin'): ?>
                                        <?php $__currentLoopData = $UserChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($child->id); ?>"><?php echo e($child->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <?php for($i = 0; $i < count($UserChildren); $i++): ?>
                                            <option value="<?php echo e($UserChildren[$i]['id']); ?>"><?php echo e($UserChildren[$i]['name']); ?>

                                            </option>
                                        <?php endfor; ?>
                                    <?php endif; ?>
                                </select>
                            </div>

                            <div class="col-6" style="float:right;">
                                <button type="submit" class="btn btn-primary">Add Member</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div id="inputFormRow">
                        <div class="row card-body">
                            <div class="col-4">
                                <p class="login-box-msg">Country</p>
                                <select name="country_id[]" class="select2 custom-select form-control-border"
                                    id="Country">
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?>

                                            +<?php echo e($country->phonecode); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-6">
                                <p class="login-box-msg">phone number</p>
                                <input type="text" class="form-control m-input" value="<?php echo e(old('phone_number')); ?>"
                                    placeholder="Phone Number" name="mobile_number[]" id="phone" required>
                            </div>

                            <button id="addRow" type="button" class="btn btn-info" style="margin-top:33px">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <div id="newRow"></div>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="select2 custom-select form-control-border" id="Country">
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?> +<?php echo e($country->phonecode); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" value="<?php echo e(old('phone_number')); ?>"
                    placeholder="Phone Number" minlength="9" id="phone" oninvalid="this.setCustomValidity('Minimum length is 9 char')" name="mobile_number[]">
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });
        // remove row
        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/users/create.blade.php ENDPATH**/ ?>