

<?php $__env->startSection('content'); ?>
    <style>
        h4 {
            font-size: 20px;
        }
    </style>
    <div class="card">
        <div class="card-header">
            <form action="<?php echo e(route('hideBuilding', $building->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-edit')): ?>
                    <a href="<?php echo e(route('buildings.edit', $building->id)); ?>">
                        <button class="btn btn-square btn-info" type="button"><i class="fas fa-pen"></i></button>
                    </a>
                <?php endif; ?>

                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-delete')): ?>
                    <button onClick="clickDeletebutton(this)" type="button" title="Delete" class="btn btn-danger"
                        data-id="<?php echo e($building->id); ?>" data-toggle="modal" data-target="#buildingModal">
                        <i class="fa fa-ban"></i>
                    </button>
                <?php endif; ?>

                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-hide')): ?>
                        <button type="submit" style="float:right"
                            class="btn btn-<?php echo e($building->is_active == 0 ? 'light' : 'dark'); ?>"
                            title="<?php echo e($building->is_active == 0 ? 'unhide' : 'hide'); ?>">
                            <i class="fas fa-<?php echo e($building->is_active == 0 ? 'eye' : 'eye-slash'); ?>"></i>
                        </button>
                <?php endif; ?>
            </form>

        </div>
        <div class="card-body">
            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Building Name :</h4>
                <h4 class="col-form-h4"><?php echo e($building->name); ?> </h4>
            </div>

            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Active :</h4>
                <h4 class="col-form-h4"><?php echo e($building->is_active == 0 ? 'Not Available' : 'Available'); ?> </h4>
            </div>
            <?php if($building->phase->project->is_residential == 1): ?>
                <div class=" row">
                    <h4 style="font-weight:bold" class="col-3">Building Type :</h4>
                    <h4 class="col-form-h4"><?php echo e($building->type); ?> </h4>
                </div>
                <div class=" row">
                    <h4 style="font-weight:bold" class="col-3">Number Of Floors :</h4>
                    <h4 class="col-form-h4">G+ <?php echo e($building->number_of_floors); ?> </h4>
                </div>
            <?php endif; ?>
            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Phase Name :</h4>
                <h4 class="col-form-h4">
                    <a href="<?php echo e(route('phases.show', $building->phase->id)); ?>">
                        <?php echo e($building->phase->name); ?>

                        <?php echo e($building->phase->project->is_residential == 0 ? ' - ' . $building->phase->type : ''); ?>

                    </a>
                </h4>
            </div>

            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Project Name :</h4>
                <h4 class="col-form-h4">
                    <a href="<?php echo e(route('projects.show', $building->phase->project->id)); ?>">
                        <?php echo e($building->phase->project->name); ?>

                    </a>
                </h4>
            </div>

            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Created at :</h4>
                <h4 class="col-form-h4"><?php echo e($building->created_at); ?> </h4>
            </div>
        </div>
        <br>
    </div>

    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-read')): ?>
        <div class="card">
            <div class="card-header">
                <h3 class="card-title" style="font-weight: bold;">Units
                    <p>Total: <?php echo e(count($units)); ?></p>
                </h3>&nbsp; &nbsp;
                <div style="float:right">
                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-uploads')): ?>
                        <a class="btn btn-secondary" data-toggle="modal" style="float:right" title="Import Units"
                            data-target='#UploadFileModal'>
                            <i class="fas fa-file-import"></i>
                        </a>
                    <?php endif; ?>

                    <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-create')): ?>
                        <a href="<?php echo e(route('units.create', 'id=' . $building->id)); ?>" title="create unit">
                            <button class="btn btn-square btn-light active" type="button"><i
                                    class="fas fa-plus"></i></button>
                        </a>
                    <?php endif; ?>

                </div>
            </div>
            <div class="card-body">
                <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('units-export') ? 'example1' : 'nonExport'); ?> 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <?php if($building->phase->project->is_residential == 1): ?>
                                <th>Floor</th>
                            <?php endif; ?>
                            <th>Unit Total Price</th>
                            <th>Unit Space</th>
                            <th>Status</th>
                            <th>Client ID</th>
                            <th>Client Name</th>
                            <th>Created Date</th>
                            <th>Created Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $unit->created_at); ?>
                            <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-show')): ?>
                                <tr class='clickable-row' data-href='<?php echo e(route('units.show', $unit->id)); ?>'>
                                <?php else: ?>
                                <tr>
                            <?php endif; ?>
                            <td><?php echo e($unit->id); ?></td>
                            <td>
                                <a href="<?php echo e(route('units.show', $unit->id)); ?>">
                                    <?php echo e($unit->name); ?>

                                </a>
                            </td>

                            <?php if($building->phase->project->is_residential == 1): ?>
                                <td><?php echo e($unit->floor == 0 ? 'Ground' : $unit->floor); ?></td>
                            <?php endif; ?>

                            <td><?php echo e($unit->unit_total_price); ?></td>
                            <td><?php echo e($unit->unit_space); ?></td>


                            <td><?php echo e($unit->status == 'taken' ? 'Contracted' : $unit->status); ?></td>
                            <td><?php echo e($unit->client?->id ?? ''); ?></td>
                            <td><?php echo e($unit->client?->name ?? ''); ?></td>

                            <td><?php echo e($temp[0]); ?></td>
                            <td><?php echo e($temp[1]); ?></td>

                            <td>
                                <?php if(auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-edit')): ?>
                                    <a class="btn btn-info" title="Edit" href="<?php echo e(route('units.edit', $unit->id)); ?>">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                <?php endif; ?>

                                <?php if($unit->status == 'free'): ?>
                                    <a class="btn btn-<?php echo e($unit->is_active == 0 ? 'info' : 'danger'); ?>"
                                        title="<?php echo e($unit->is_active == 0 ? 'unhide' : 'hide'); ?>"
                                        href="<?php echo e(route('hideUnit', $unit->id)); ?>">
                                        <?php echo e($unit->is_active == 0 ? 'unhide' : 'hide'); ?>

                                    </a>
                                <?php endif; ?>

                                
                            </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalCenter" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Delete Record</h5>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure to delete this record ?</p>
                            </div>
                            <form class="modal-footer" method="post">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="modal fade" id="buildingModal" tabindex="-1" role="dialog" aria-labelledby="buildingModal"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <?php if(count($building->units) == 0): ?>
                        <p>Are you sure to delete this record ?</p>
                    <?php else: ?>
                        <p>this Building has units you can't delete this Building</p>
                    <?php endif; ?>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <?php if(count($building->units) == 0): ?>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    <form action="<?php echo e(route('units.import')); ?>" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UploadFileModal" tabindex="-1" role="dialog" aria-labelledby="UploadFileModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import Units</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="upload-sheet" class="btn btn-outline-info" title="upload Sheet">
                                Upload Sheet &nbsp;
                            </label>
                            <input type="file" name="file" id="upload-sheet" style="display:none">
                        </div>
                    </div>
                    <?php echo csrf_field(); ?>
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <!-- /.row -->
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('units.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('buildings.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#buildingModal').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/buildings/show.blade.php ENDPATH**/ ?>