

<?php $__env->startSection('content'); ?>
    <div class="card col-3">
        <!-- View -->
        <div class="card-header">
            <div class="row">
                <h4 class="col-10">Manage Facilities</h4>
                <button id="addRow" type="button" title="add facility" class="btn btn-light">
                    <i class="fas fa-plus"></i>
                </button>
            </div>
        </div>
        <div class="card-body">
            <div id="inputFormRow">
                <div class="row">
                    <?php $__empty_1 = true; $__currentLoopData = $facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="col-10">
                            <input type="text" class="form-control m-input" value="<?php echo e($facility->name); ?>" readonly>
                        </div>
                        <div class="col-2">
                            <?php if(count($facility->projects) == 0): ?>
                                <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                    class="btn btn-danger" data-id="<?php echo e($facility->id); ?>" data-toggle="modal"
                                    data-target="#exampleModalCenter">
                                    <i class="fa fa-ban"></i>
                                </button>
                            <?php endif; ?>
                        </div>
                        <br><br>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php endif; ?>
                </div>
                <form action="<?php echo e(route('facilities.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div id="newRow"></div>
            </div>
            <div class="card-footer" style="display:flex;justify-content:center;">
                <button type="submit" class="btn btn-info">Submit</button>
            </div>
            </form>
        </div>
    </div>

    

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
            <div id="inputFormRow">
                <div class="row" style="margin-top:20px;">
                    <div class="col-10">
                        <input type="text" class="form-control m-input" placeholder="Facility Name"
                                name="name[]" required>
                    </div>
                    <div class="col-2" style="padding-top:35px;margin-top:-35px">
                        <button id="removeRow" type="button" class="btn btn-danger">
                        <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
            </div>`;
            $('#newRow').append(html);
        });

        // remove row
        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });


        clickDeletebutton = (e) => {
            let modelId = e.getAttribute("data-id");
            console.log(modelId);
            var route = "<?php echo e(route('facilities.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/facilities/create.blade.php ENDPATH**/ ?>