<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Role;
use App\Models\Permission;
use App\Models\Team;
use App\Models\Country;
use App\Models\PhoneNumber;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Facades\Password;

use function PHPUnit\Framework\isEmpty;

class UserController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('permission:users-create',['only' => ['create', 'store']]);
    //     $this->middleware('permission:users-read',['only' => ['show']]);
    //     $this->middleware('permission:users-update',['only' => ['edit', 'update']]);
    //     $this->middleware('permission:users-delete',['only' => ['destroy']]);

    // }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $CurrentUser = auth()->user();
        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event('Visit Users Index')
            ->log($CurrentUser->name . ' viewed users index');


        if (auth()->user()->type == 'admin') {
            $UserChildren = User::where('is_blocked', 0)->get();
        } else {
            $users = User::where('is_blocked', 0)->get();

            $UserChildren = array();
            foreach ($users as $userr) {
                // dd($user);
                $parents = $userr->getParents()->pluck('id')->toArray();
                if (in_array($CurrentUser->id, $parents)) {
                    array_push($UserChildren, [
                        'id' => $userr->id,
                        'name' => $userr->name
                    ]);
                }
            }
        }

        return view('users.index', compact('UserChildren'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        dd('something');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        dd($request);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(User $user)
    {
        // user profile
        $userPermissions = $user->permissions()->pluck('name');

        if ($userPermissions->isEmpty()) {
            $userPermissions = '';
        }

        $CurrentUser = auth()->user();
        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event("Visit User's Profile")
            ->log('User (' . $CurrentUser->name . ') Visited the profile of user (' . $user->name . ') ');

        return view('users.show', compact('user', 'userPermissions'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(User $user)
    {

        // Get User Children
        $users = User::get();
        $CurrentUser = auth()->user();

        if($CurrentUser->type == 'admin'){
            $UserChildren = User::get();    
        }else{

            $UserChildren = array();
            foreach ($users as $userr) {
                // dd($user);
                $parents = $userr->getParents()->pluck('id')->toArray();
                if (in_array($CurrentUser->id, $parents)) {
                    array_push($UserChildren, [
                        'id' => $userr->id,
                        'name' => $userr->name
                    ]);
                }
            }
        }

        // Get User Role Children
        $roles = Role::get();

        $permissions = array();

        $userPermissions = $user->permissions()->pluck('id')->toArray();
        $countries = Country::all();

        $CurrentUser = auth()->user();
        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event("Visit User's Edit Page")
            ->log('User (' . $CurrentUser->name . ') Visited the Edit Page of user (' . $user->name . ') ');

        return view('users.edit', compact('user', 'countries', 'UserChildren', 'roles'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, User $user)
    {
        if ($request->password) {
            $user->password = Hash::make($request->password);
            $user->save();
        }
        
        if($request->role_id)
        {
            $user->update([
            'name' => $request->name,
            'email' => $request->email,
            'role_id' => $request->role_id,
            'assigned_to' => $request->assigned_to
        ]);
        }else{
            $user->update([
            'name' => $request->name,
            'email' => $request->email,
        ]);
        }
        
        // $user->attachRole($request->role_id);
        if (count($user->phones) != 0) {
            foreach ($user->phones as $phone) {
                $phone->delete();
            }
        }

        if ($request->mobile_number) {
            $counts = count($request->mobile_number);
            for ($i = 0; $i < $counts; $i++) {
                $phones = new PhoneNumber;

                $phones->phone = $request->mobile_number[$i];
                $phones->user_id = $user->id;
                $phones->country_id = $request->country_id[$i];
                $phones->save();
            }
        }

        if ($request->permissions) {
            $user->syncPermissions($request->permissions);
            // if($request->team)
            // {
            //     $user->syncPermissions($request->permissions,$request->team);
            // }
            // else
            // {
            //     foreach($user->allTeams() as $team)
            //     {
            //         $user->detachPermissions($user->permissions,$team);
            //     }
            //     $user->syncPermissions($request->permissions);
            // }

        } else {
            //$user->detachPermissions($user->permissions,$request->team);
            $user->detachPermissions($user->permissions);
        }

        $userModel = new User();
        $CurrentUser = auth()->user();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event('Update User Profile')
            ->log('User (' . $CurrentUser->name . ') Updated Profile of user (' . $user->name . ') ');


        return redirect()->route('users.show', $user->id)
            ->with('success', 'user updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(User $user, $id)
    {
        $user = User::find($id);
        activity()
            ->event('delete')
            ->log(auth()->user()->name . 'deleted user: ' . $user->name);

        $user->delete();
        return redirect()->route('users.index')
            ->with('success', 'User deleted successfully');
    }

    public function profile()
    {
        $id = Auth::user()->id;

        $role_id = DB::table('role_user')->where('user_id', $id)->first();

        if ($role_id) {
            $userType = DB::table('roles')->where('id', $role_id->role_id)->first();
            $userType = $userType->name;
        } else {
            $userType = null;
        }

        return view('auth.profile', compact('userType'));
    }

    public function editProfile(User $user)
    {
        return view('auth.editProfile', compact('user'));
    }

    public function updateProfile(Request $request, User $user)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required',
            'password' => ['nullable', 'confirmed', 'min:6']
        ]);

        if ($request->password != NULL) {
            $user->update([
                'name' => $request->name,
                'email' => $request->email,
                'password' => Hash::make($request->password)
            ]);
        } else {
            $user->update([
                'name' => $request->name,
                'email' => $request->email
            ]);
        }

        return redirect()->route('profile')
            ->with('success', 'Profile updated successfully');
    }


    public function block($id)
    {
        $user = User::find($id);
        $user->is_blocked = 1;
        $user->save();

        $CurrentUser = auth()->user();
        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event("Blocking User")
            ->log('User (' . $CurrentUser->name . ') Blocked user (' . $user->name . ') ');


        return redirect()->route('users.index')
            ->with('success', 'user blocked successfully');
    }

    public function blocklist()
    {
        $users = User::where('is_blocked', 1)->get();

        $user = auth()->user();
        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($user)
            ->event('Visit Users BlockList')
            ->log('User (' . $user->name . ') Visited Users  BlockList Page ');

        return view('users.blocklist', compact('users'));
    }

    public function unblock($id)
    {
        $user = User::find($id);
        $user->is_blocked = 0;
        $user->save();

        $CurrentUser = auth()->user();
        $userModel = new User();

        activity()
            ->performedOn($userModel)
            ->causedBy($CurrentUser)
            ->event("unBlock User")
            ->log('User (' . $CurrentUser->name . ') un-Blocked user (' . $user->name . ') ');

        return redirect()->route('users.index')
            ->with('success', 'user blocked successfully');
    }

    public function usersTree()
    {
        $allUsers = User::get();
        $users = User::where('assigned_to', null)->get();
        $parentCodes = User::where('assigned_to', '!=', null)->get();
        $arrayOfCodes = [];
        foreach ($parentCodes as $code) {
            array_push($arrayOfCodes, $code->assigned_to);
        }
        $userModel = new User();
        $user = auth()->user();

        activity()
            ->performedOn($userModel)
            ->causedBy($user)
            ->event('Visit Users Tree')
            ->log('User (' . $user->name . ') Visited Users Tree Page ');

        return view('users.tree', compact('users', 'arrayOfCodes', 'allUsers'));
    }
}
