<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Agent extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LogsActivity;
    
    public $guarded = [];
    protected $table = 'agents';

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logUnguarded()->logOnlyDirty()->setDescriptionForEvent(fn (string $eventName) => "This model has been {$eventName}")->useLogName('Agent Action');;
    }

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }

    public function brokers()
    {
        return $this->belongsToMany(Broker::class, 'agent_broker');
    }

    public function communications()
    {
        return $this->hasMany(Communication::class);
    }
    public function inquiries()
    {
        return $this->hasMany(Inquiry::class);
    }
    public function leads()
    {
        return $this->hasMany(Lead::class);
    }
}
