<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Campaign extends Model
{
    use HasFactory,SoftDeletes;

    protected $guarded = [];

    protected $dates = ['deleted_at'];

    public function leads()
    {
        return $this->hasMany(Lead::class);
    }

    public function sources()
    {
        return $this->hasMany(Source::class);
    }

    public function project(){
        return $this->belongsTo(Project::class);
    }

    public function inquiries()
    {
        return $this->hasMany(Inquiry::class);
    }
}
