<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Facility extends Model
{
    use HasFactory;
    public $guarded = [];

    public function projects()
    {
        return $this->belongsToMany(Project::class, 'facility_projects');
    }

    public function unit()
    {
        return $this->belongsToMany(Unit::class, 'facility_units');
    }

    public function facility_units()
    {
        return $this->hasOne(FacilityUnit::class);
    }
}
