@extends ('../welcome')

<style>
    .pagination nav .relative.z-0.inline-flex {
        display: inline-flex;
    }

    .pagination nav .hidden {
        display: unset !important;
    }

    .pagination nav .flex-1.justify-between {
        padding: 15px 0
    }

    .pagination nav .flex.justify-between.flex-1 {
        display: none
    }
</style>
@section('content')
    <!-- Filters -->
    <div class="card">
        <div class="card-body">
            <form action="{{ route('logsActivities.index') }}">
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>Users</label>
                            <select name="user_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" value="{{ $_GET['time1'] ?? '' }}" class="form-control"
                                    name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>to</label>

                                <input type="time" name="time2" value="{{ $_GET['time2'] ?? '' }}"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="{{ $_GET['date1'] ?? '' }}"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="{{ $_GET['date2'] ?? '' }}"
                                    class="form-control">
                            </div>
                        </div>

                        <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:left">filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    <!-- End filters -->

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
            <div class="card-title">Total: {{ $logs->total() }}</div>
                    
                    <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('logs-export') ? 'example2' : 'nonExport' }} class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th class="filters">User</th>
                                <th class="filters">Log</th>
                                <th class="filters">Action</th>
                                <th class="filters">Date</th>
                                <th class="filters">Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($logs as $log)
                                <?php
                                $temp = explode(' ', $log->created_at);
                                ?>
                                <tr>
                                    <td>{{ $log->causer?->name }}</td>
                                    <td>{{ $log->description }}</td>
                                    <td>{{ $log->event }}</td>
                                    <td>{{ $temp[0] }}</td>
                                    <td>{{ $temp[1] }}</td>
                                </tr>
                            @empty
                            @endforelse

                        </tbody>
                        <tfoot>
                            <tr>
                                <th>User</th>
                                <th>log</th>
                                <th>Action</th>
                                <th>date</th>
                                <th>time</th>
                            </tr>
                        </tfoot>
                    </table>
                    <div class="pagination">
                        {{ $logs->appends(request()->input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- jQuery -->
@endsection
