@extends ('../welcome')
@section('content')
<style>
html {
    width: 2000.520px;
}

h6 {
    font-weight: bold;
}
</style>
<div class="card card-light">
    <div class="card-header">
        <h3 class="card-title">{{$unit->client?->name}} - {{$unit->name}}</h3>
        <a href="{{route('batches.create', $unit->id)}}" title="Create Batch" class="btn btn-light"
            style="float:right;">
            <i class="fas fa-plus"></i>
        </a>
        @if($unit->client)
        <a href="{{route('clients.show', $unit->client->id)}}" title="{{$unit->client->name}}" class="btn btn-light"
            style="float:right;">
            <i class="fas fa-user"></i>
        </a>
        @endif
        <a href="{{route('units.show', $unit->id)}}" class="btn btn-light" title="{{$unit->name}}" style="float:right;">
            <i class="fas fa-home"></i>
        </a>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-6">
                <div class="row">
                    <h6>Total Paid For Unit: &nbsp</h6>
                    <p>{{$totalPaid_unit}}</p>
                </div>
                <div class="row">
                    <h6>Total Remaining For Unit: &nbsp</h6>
                    <p>{{$unit->client ? $totalRemaining_unit : $totalRemaining_unit . '%'}}</p>
                </div>

            </div>
            <div class="col-6">
                <div class="row">

                    <h6>Total Paid for Maintenance: &nbsp</h6>
                    <p>{{$totalPaid_maintenance}}</p>
                </div>
                <div class="row">
                    <h6>Total Remaining for Maintenance: &nbsp</h6>
                    <p>{{$unit->client ? $totalRemaining_maintenance : $totalRemaining_maintenance . '%'}}</p>
                </div>
            </div>
        </div>
        <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('batches-export') ? 'example1' : 'nonExport' }} 
            class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Type</th>
                    <th>Amount</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Checked by</th>
                    @if($totalRemaining_maintenance != 0 || $totalRemaining_unit != 0)
                    <th>Actions</th>
                    @endif

                </tr>
            </thead>
            <tbody>
                <?php  $i = 0;?>
                @foreach ($unit->batches as $batch)
                <?php $temp = explode(' ',$batch->date);
                        $i++;
                    ?>

                <tr>
                    <td>{{$batch->title ?? ''}}</td>
                    <td>{{$batch->type ?? ''}}</td>
                    <td>{{$batch->amount ?? ''}}</td>
                    <td>{{$unit->client ? $temp[0] : ''}}</td>
                    <td>{{$batch->status ?? ''}}</td>
                    <td>{{$batch->user?->name ?? ''}}</td>
                    @if($totalRemaining_maintenance != 0 || $totalRemaining_unit != 0)
                    <td>
                        <div class="row">
                            @if($batch->status != 'paid')
                            <a href="{{route('SavePayment', $batch->id)}}" title="Set Batch as Paid"
                                class="btn btn-success">
                                <i class="fas fa-check"></i>
                            </a>

                            <a href="{{route('batches.edit', $batch->id)}}" title="edit" class="btn btn-info">
                                <i class="fas fa-pen"></i>
                            </a>

                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                data-id="{{$batch->id}}" data-toggle="modal" data-target="#exampleModalCenter">
                                <i class="fa fa-ban"></i>
                            </button>

                            @endif

                        </div>
                    </td>
                    @endif
                </tr>

                @endforeach
            </tbody>
        </table>
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Record</h5>
                        <!-- <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button> -->
                    </div>
                    <div class="modal-body">
                        <p>Are you sure to delete this record ?</p>
                    </div>
                    <form class="modal-footer" method="post">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
<script>
clickDeletebutton = (e) => {
    const modelId = e.getAttribute("data-id");
    var route = "{{route('batches.destroy',':id')}}";
    route = route.replace(':id', modelId);
    $('#exampleModalCenter').find($('form')).attr('action', route);
}
</script>
@endsection