@extends ('../welcome')
@section('content')
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>
    <!-- Filters -->
    <form>
        <div class="card card-info card-outline collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title" style="font-weight:bold; font-size:20px">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <form>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label>Creator</label>
                                <select name="creators_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($creators as $creator)
                                        <option value="{{ $creator->id }}">{{ $creator->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label>brokers</label>
                                <select name="brokers_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($brokers as $broker)
                                        <option value="{{ $broker->id }}">{{ $broker->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Agents</label>
                                <select name="agents_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($agents as $agent)
                                        <option value="{{ $agent->id }}">{{ $agent->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-6">
                            <div class="row">
                                <div class="form-group col-6">
                                    <label>Type</label>
                                    <select name="type[]" class="select2 custom-select form-control-border" multiple>
                                        <option value="call">call</option>
                                        <option value="follow_up">follow up</option>
                                        <option value="site">site</option>
                                        <option value="Visit">Visit</option>
                                    </select>
                                </div>
                                <div class="form-group col-6">
                                    <label>State</label>
                                    <select name="state[]" class="select2 custom-select form-control-border" multiple>
                                        <option value="todo">to do</option>
                                        <option value="in_progress">in progress</option>
                                        <option value="done">done</option>
                                        <option value="cancel">cancel</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-6">
                                    <label>From</label>
                                    <input type="time" value="{{ $_GET['time1'] ?? '' }}" class="form-control"
                                        name="time1">
                                </div>
                                <div class="form-group col-6">
                                    <label>to</label>

                                    <input type="time" name="time2" value="{{ $_GET['time2'] ?? '' }}"
                                        class="form-control">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-6">
                                    <input type="date" name="date1" value="{{ $_GET['date1'] ?? '' }}"
                                        class="form-control">
                                </div>
                                <div class="form-group col-6">
                                    <input type="date" name="date2" value="{{ $_GET['date2'] ?? '' }}"
                                        class="form-control">
                                </div>
                            </div>

                            <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                            <button type="submit" class="btn btn-info" style="float:left">filter</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </form>

    <!-- End filters -->

    <!-- /.Table Card-->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title"> Activities </h5>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('brokers-create-activities'))
                        <button type="button" class="btn btn-light" style="float:right" title="create activity Actions"
                            data-toggle="modal" data-target="#myModal">
                            <i style="color:black" class="fas fa-phone"></i>
                        </button>
                    @endif
                </div>
                <div class="card-body">
                    <div class="card-title">Total: {{ count($totalActions) }}</div>
                    <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('agent-activities-export') ? 'example2' : 'nonExport' }} 
                         class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Type</th>
                                <th>State</th>
                                <th>broker</th>
                                <th>Agent</th>
                                <th>check in</th>
                                <th>Creator</th>
                                <th>To Do Date</th>
                                <th>Close Date</th>
                                <th>Created at</th>
                                <th>Control</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($communications as $communication)
                                @if ($communication->agent_id != null)
                                    <tr>
                                        <td>{{ $communication->id }}</td>
                                        <td>
                                            {{ $communication->type ?? '' }}
                                        </td>
                                        <td>
                                            {{ $communication->state ?? '' }}
                                        </td>

                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('brokers-show'))
                                                <a href="{{ route('brokers.show', $communication->broker->id) }}">
                                                    {{ $communication->broker->name ?? '' }}
                                                </a>
                                            @else
                                                <a>
                                                    {{ $communication->broker->name ?? '' }}
                                                </a>
                                            @endif
                                        </td>
                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('agents-show'))
                                                <a href="{{ route('agents.show', $communication->agent_id) }}">
                                                    {{ $communication->agent->name ?? '' }}
                                                </a>
                                            @else
                                                <a>
                                                    {{ $communication->agent->name ?? '' }}
                                                </a>
                                            @endif
                                        </td>
                                        <td>
                                            {{ $communication->check_in == 0 ? 'no' : 'yes' }}
                                        </td>

                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-show'))
                                            <td>
                                                <a href="{{ route('users.show', $communication->user->id) }}">
                                                    {{ $communication->user?->name }}
                                                </a>
                                            </td>
                                        @else
                                            {{ $communication->user?->name ?? '' }}
                                        @endif

                                        <td>{{ $communication->event?->start }}</td>
                                        <td>{{ $communication->event?->end }}</td>
                                        <td>{{ $communication->created_at }}</td>

                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('communications-show'))
                                                <form action="" method="POST">
                                                    <a class="btn btn-light" title="Show"
                                                        href="{{ route('communications.show', $communication->id) }}">
                                                        <i class="fa fa-eye"></i>
                                                    </a>
                                                    @csrf
                                                </form>
                                            @endif
                                        </td>
                                    </tr>
                                @endif
                            @endforeach
                        </tbody>
                    </table>
                    <div class="pagination">
                        {{ $communications->appends(request()->input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="myModal" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Create Activity </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                </div>
                <form action="{{ route('communications.store') }}" method="POST">
                    <div class="modal-body">
                        @csrf
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <label for="type">Type: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="type" class="select2 custom-select form-control-border"
                                            id="type">
                                            <option value="call">call</option>
                                            <option value="follow_up">follow up</option>
                                            <option value="site">site</option>
                                            <option value="Visit">Visit</option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="state">State: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="state" class="select2 custom-select form-control-border"
                                            id="state">
                                            <option value="todo">to do</option>
                                            <option value="in_progress">in progress</option>
                                            <option value="done">done</option>
                                            <option value="cancel">cancel</option>
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="broker">broker: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="broker_id" class="custom-select form-control-border"
                                            id="broker">
                                            <option value=""></option>
                                            @foreach ($brokers as $broker)
                                                <option value="{{ $broker->id }}">{{ $broker->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="agents">Agents: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="agent_id" class="select2 custom-select form-control-border"
                                            id="agents">
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="start">To Do: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="start"
                                            value="{{ date('Y-m-d H:i:s') }}" name="start_date"
                                            min="{{ date('Y-m-d H:i:s') }}">
                                    </td>
                                </tr>
                                <tr id="reminderInput">
                                    <td>
                                        <label for="reminder">Reminder: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="reminder" name="reminder"
                                            min="{{ date('Y-m-d H:i:s') }}">
                                    </td>
                                </tr>

                                <tr id="endInput" style="display:none">
                                    <td>
                                        <label for="end">Close: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="datetime-local" class="form-control" id="end"
                                            value="{{ date('Y-m-d H:i:s') }}" name="end_date"
                                            min="{{ date('Y-m-d H:i:s') }}">
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description"></textarea>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="checkIn">Check In: </label>
                                    </td>
                                    <td colspan="3">
                                        <input type="checkbox" name="check_in" id="checkIn" value="1">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script>
        $(document).on('change', '#broker', function() {
            console.log(this.value);
            var data = this.value;

            $.ajax({
                data: {
                    'broker_id': data
                },
                method: "POST",
                url: "{{ route('brokerAgents') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    console.log(dataResult.agents);
                    let agents = "";


                    Array.from(dataResult.agents).forEach(myFunction2);

                    function myFunction2(item, index) {
                        agents += `<option value="` + item.id + `">` + item.name + `</option>`;
                    }
                    document.getElementById("agents").innerHTML = agents;
                }
            });
        });

        $("#checkIn").change(function() {
            if (this.checked) {
                $('#reminderInput').hide();
                $('#endInput').show();
            } else {
                $('#reminderInput').show();
                $('#endInput').hide();

            }
        });
    </script>
@endsection
