@extends ('../welcome')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Brokers</h3><br>
            <p>Total: {{ count($brokers) }}</p>
            @if (auth()->user()->role->hasPermission('brokers-restorAll'))
                <a href="{{ route('brokers.restoreAll') }}" title="Restore All" style="float:right">
                    <button class="btn btn-square btn-outline-success" type="button"><i
                            class="fas fa-trash-restore-alt"></i></button>
                </a>
            @endif
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('broker-archive-export') ? 'example1' : 'nonExport' }} 
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>type</th>
                        <th>Owner Name</th>
                        <th>Sales Admin</th>
                        <th>Authorized Name</th>
                        <th>Sales Man</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        <th>Restore</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($brokers as $broker)
                        <?php $temp = explode(' ', $broker->created_at->setTimezone('Africa/Cairo')); ?>
                        <tr>
                            <td>{{ $broker->id }}</td>
                            <td>
                                <a href="{{ route('brokers.show', $broker->id) }}">
                                    {{ $broker->name }}
                                </a>
                            </td>
                            <td>{{ $broker->email }}</td>
                            <td>{{ $broker->type }}</td>
                            <td>{{ $broker->owner_name }}</td>
                            <td>{{ $broker->sales_admin }}</td>
                            <td>{{ $broker->authorized_name }}</td>
                            <td>{{ $broker->salesMan->name }}</td>
                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>
                            <td>
                                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('broker-restore'))
                                    <a class="btn btn-outline-light" title="Restore"
                                        href="{{ route('broker.Restore', $broker->id) }}">
                                        <i class="fas fa-trash-restore-alt"></i>
                                    </a>
                                @endif

                                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('delete-permanently'))
                                    <a href="{{ route('broker.deletePermanently', $broker->id) }}">
                                        <button title="Delete" class="btn btn-danger">
                                            <i class="fa fa-ban"></i>
                                        </button>
                                    </a>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
