@extends ('../welcome')


@section ('content')
  <div class="card">
    <div class="card-body   gister-card-body">
      <p class="login-box-msg">Edit Campaign</p>

      <form  action="{{ route('campaigns.update',$campaign->id) }}" method="POST">
        @csrf
        @method('PUT')
        <input type="hidden" value="{{$campaign->id}}" name="id">
        <div class="form-group mb-3">
            <label>Name</label>
          <input type="text" name="name" value="{{old('name',$campaign->name)}}" class="form-control">
        </div>
        <div class="form-group mb-3">
            <label>Description</label>
          <textarea type="text" class="form-control" cols="6" rows="8" value="{{old('description')}}"  name="description">{{$campaign->description}}</textarea>
        </div>
        <div class="form-group mb-3">
            <label>Status</label>
            <select name="status" class="select2 custom-select form-control-border" id="status">
                <option value="planning" {{old('status',$campaign->status) == 'planning' ?'selected':''}}>Planning</option>
                <option value="active" {{old('status',$campaign->status) == 'active' ?'selected':''}}>Active</option>
                <option value="inactive" {{old('status',$campaign->status) == 'inactive' ?'selected':''}}>In-Active</option>
                <option value="complete" {{old('status',$campaign->status) == 'complete' ?'selected':''}}>Complete</option>
            </select>
        </div>
        <div class="form-group mb-3">
            <label>Start Date</label>
          <input type="date" class="form-control" value="{{old('start_date',$campaign->start_date)}}" name="start_date">
        </div>
        <div class="form-group mb-3">
            <label>End Date</label>
          <input type="date" class="form-control" value="{{old('end_date',$campaign->end_date)}}" name="end_date">
        </div>
        <div class="form-group mb-3">
            <label>Budget</label>
          <input type="number" step="0.01" class="form-control" value="{{old('budget',$campaign->budget)}}" name="budget">
        </div>
        <div class="form-group mb-3">
                <label>Target</label>
                <input type="text" class="form-control" value="{{old('budget',$campaign->target)}}" name="target">
            </div>
            <div class="form-group mb-3">
                <label>Purpose</label>
                <input type="text" class="form-control" value="{{old('budget',$campaign->purpose)}}" name="purpose">
            </div>
        {{--<div class="form-group mb-3">
            <label>Type</label>
            <select name="type" class="select2 custom-select form-control-border" id="type">
                <option value="facebook" {{old('type',$campaign->type) == 'facebook' ?'selected':''}}>Facebook</option>
                <option value="twitter" {{old('type',$campaign->type) == 'twitter' ?'selected':''}}>Twitter</option>
                <option value="instagram" {{old('type',$campaign->type) == 'instagram' ?'selected':''}}>Instagram</option>
                <option value="google-ads" {{old('type',$campaign->type) == 'google-ads' ?'selected':''}}>Google Ads</option>
            </select>
        </div>--}}
        <div class="form-group mb-3">
                <label>Projects</label>
                <select name="project_id" class="select2 custom-select form-control-border" id="projects">
                    <option value=""></option>
                    @forelse($projects as $project)
                    <option value="{{$project->id}}" {{$project->id == $campaign->project?->id ? 'selected' : ''}}>{{$project->name}}</option>
                    @empty
                    @endforelse
                </select>
            </div>

          <div class="col-6" style="float:right;">
            <button type="submit" class="btn btn-primary">Submit</button>
          </div>
          <!-- /.col -->
        </div>
      </form>
    </div>
    <!-- /.form-box -->
  </div><!-- /.card -->
@endsection

