@extends ('../welcome')


@section('content')
    <form action="{{ route('clients.store') }}" method="POST">
        @csrf
        <div class="card">
            <div class="card-header">
                <p class="login-box-msg text-info" style="font-weight:bold">Create Client Profile</p>
            </div>
            <div class="card-body register-card-body">

                <div class="row">
                    <div class="col-6">
                        <!-- Left Side -->
                        @if (isset($lead))
                            <input type="hidden" value="{{ $lead->id }}" name="leadId">
                        @endif
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Name</label>
                            @if (!empty($lead))
                                <input type="hidden" name="name" value="{{ $lead->name }}">
                                <input type="text" readonly name="name" value="{{ $lead->name }}"
                                    class="form-control">
                            @else
                                <input type="text" name="name" placeholder="Client Name" class="form-control">
                            @endif
                        </div>
                        <br>
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Email</label>
                            @if (isset($lead))
                                <input type="hidden" name="email" value="{{ $lead->email }}">
                                <input type="email" readonly class="form-control" placeholder="email@example.com"
                                    value="{{ $lead->email }}" name="email">
                            @else
                                <input type="email" class="form-control" placeholder="email@example.com" name="email">
                            @endif
                        </div>

                        <br>
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Job Title</label>
                            @if (isset($lead))
                                <input type="hidden" name="job_title" value="{{ $lead->job_title }}">
                                <input type="text" readonly class="form-control" value="{{ $lead->job_title }}"
                                    name="job_title">
                            @else
                                <input type="text" class="form-control" placeholder="ex: Developer" name="job_title">
                            @endif
                        </div>
                        <br>
                        {{-- @if($lead->campaign_id != NULL || $lead->source_id != NULL) --}}
                        <div class="col-10 mb-3" style="display: inline-block;">
                            <label for="campaign_id">Campaign</label>
                            <input type="hidden" name="campaign_id" value="{{ $lead->campaign_id ?? ''}}">
                            <input type="text" readonly class="form-control" value="{{ $lead->campaign?->name }}">
                        </div>

                        <div class="col-10 mb-3" style="display: inline-block;">
                            <label for="source_id">Source</label>
                            <input type="hidden" name="source_id" value="{{ $lead->source_id ?? '' }}">
                            <input type="text" readonly class="form-control" value="{{ $lead->source?->name }}">
                        </div>
                        {{-- @endif --}}
                        <div class="col-10 mb-3" style="display: inline-block">
                            <label>Came From</label>
                            <input type="text" class="form-control" value="{{ $lead->came_from }}" name="came_from">
                        </div>
                        <br>

                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID Date<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_date">
                        </div>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID City<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_city">
                        </div>
                        <br>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID Number<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_number">
                        </div>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Civil ID Address<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="civil_address">
                        </div>
                        <div class="col-5 mb-3" style="display: inline-block">
                            <label>Nationality<strong class="text-danger">*</strong></label>
                            <input type="text" class="form-control" name="nationality">
                        </div>
                        <br>

                        <br>
                        <!-- End Left Side -->
                    </div>
                    <div class="col-6">
                        <!-- right Side -->
                        <div class="col-md-12">
                            <div class="card card-outline card-info">
                                <div class="card-header">
                                    <h3 class="card-title">Mobile Number</h3>

                                    <div class="card-tools">
                                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                            <i class="fas fa-minus"></i>
                                        </button>
                                    </div>
                                    <!-- /.card-tools -->
                                </div>
                                <!-- /.card-header -->
                                <div class="card-body">
                                    <div id="inputFormRow" style="margin-left: 9px;">
                                        <div class="row">
                                            <div class="col-12" style="display: inline-block">
                                                <label></label>
                                                {{-- <button id="addRow" type="button" class="btn btn-light"
                                                    style="margin-top:0px">
                                                    Add Number <i class="fas fa-plus"></i>
                                                </button> --}}
                                                @if (isset($lead))
                                                    @foreach ($lead->phone_numbers as $mobile)
                                                        <div id="inputFormRow">
                                                            <div class="row">
                                                                <div class="col-4">
                                                                    <div class="form-group" style="margin-top:20px;">
                                                                        <input type="text" class="form-control m-input"
                                                                        value="{{ $mobile->country->name }} +{{ $mobile->country->phonecode }}" readonly>
                                                                    </div>
                                                                </div>
                                                                <div class="col-6" style="margin-top:20px;">
                                                                    <input type="text" class="form-control m-input"
                                                                        value="{{ $mobile->phone }}" id="phone"
                                                                        placeholder="Phone Number" name="mobile_number[]"
                                                                        readonly>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div id="inputFormRow">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <div class="form-group" style="margin-top:20px;">
                                                                    <select name="country_id"
                                                                        class="select2 custom-select form-control-border"
                                                                        id="Country">
                                                                        @foreach ($countries as $country)
                                                                            <option value="{{ $country->id }}">
                                                                                {{ $country->name }}
                                                                                +{{ $country->phonecode }}
                                                                            </option>
                                                                        @endforeach
                                                                    </select>
                                                                </div>
                                                            </div>
                                                            <div class="col-6" style="margin-top:20px;">
                                                                <input type="text" class="form-control m-input"
                                                                    placeholder="Phone Number" id="phone"
                                                                    name="mobile_number[]" required>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                        <div id="newRow"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer" style="text-align:center;">
                <button type="submit" class="btn btn-info" style="width:200px;">Submit</button>
            </div>
        </div>
    </form>
    <!-- /.form-box -->
    </div>
    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row">
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                    <select name="country_id"
                        class="select2 custom-select form-control-border" id="Country">
                        @foreach ($countries as $country)
                        <option value="{{ $country->id }}">
                            {{ $country->name }} +{{ $country->phonecode }}
                        </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" id="phone"
                    placeholder="Phone Number" name="mobile_number[]" required>
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });

        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script><!-- /.card -->
@endsection
