@extends ('../welcome')


@section('content')
<div class="card">
    <div class="card-body register-card-body">
        <h5 class="login-box-msg" style="color:#17a2b8; margin-right:7%;"><strong>Edit {{$client->name}}
                Profile</strong></h5>

        <form action="{{ route('clients.update',$client->id) }}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-6">
                    <!-- Left Side -->
                    <input type="hidden" value="{{$client->id}}" name="clientId">
                    <div class="col-10 mb-3" style="display: inline-block">
                        <label>Name</label>
                        <input type="text" name="name" value="{{ $client->name }}" class="form-control">
                    </div>
                    <br>
                    <div class="col-10 mb-3" style="display: inline-block">
                        <label>Email</label>
                        <input type="email" class="form-control" placeholder="email@example.com" name="email"
                            value="{{ $client->email }}" required>
                    </div>
                    <br>
                    <div class="col-10 mb-3" style="display: inline-block">
                        <label>Job Title</label>
                        <input type="text" class="form-control" value="{{ $client->job_title }}" name="job_title">
                    </div>
                    <br>
                    <div class="col-10 mb-3" style="display: inline-block">
                        <label>Came From</label>
                        <input type="text" class="form-control" value="{{ $client->came_from }}" name="came_from">
                    </div>
                    <br>
                    <div class="col-10 mb-3" style="display: inline-block;">
                        <label for="source_id">Source</label>
                        <select name="source_id" class="select2 custom-select form-control-border">
                            <option value="">Select Source</option>
                            @foreach($sources as $source)
                            <option {{ $client->source_id == $source->id ? 'selected' : '' }}
                                value="{{$source->id}}"> {{ $source->name }} </option>
                            @endforeach
                        </select>
                    </div>
                    <!-- End Left Side -->
                </div>
                <div class="col-6">
                    <!-- right Side -->
                    <div class="col-5 mb-3" style="display: inline-block">
                        <label>Civil ID Date</label>
                        <input type="text" class="form-control" name="civil_date" value="{{$client->civil_date}}">
                    </div>
                    <div class="col-5 mb-3" style="display: inline-block">
                        <label>Civil ID City</label>
                        <input type="text" class="form-control" name="civil_city" value="{{$client->civil_city}}">
                    </div>
                    <br>
                    <div class="col-5 mb-3" style="display: inline-block">
                        <label>Civil ID Number</label>
                        <input type="text" class="form-control" name="civil_number" value="{{$client->civil_number}}">
                    </div>
                    <div class="col-5 mb-3" style="display: inline-block">
                        <label>Civil ID Address</label>
                        <input type="text" class="form-control" name="civil_address" value="{{$client->civil_address}}">
                    </div>
                    <div class="col-5 mb-3" style="display: inline-block">
                        <label>Nationality</label>
                        <input type="text" class="form-control" name="nationality" value="{{$client->nationality}}">
                    </div>
                </div>
                <br>
                <!-- End right Side -->
            </div>
            <div class="col-12" style="text-align:center;">
                <button type="submit" class="btn btn-info" style="width:200px;">Submit</button>
            </div>
        </form>
    </div>
</div>
<!-- /.form-box -->
</div>
<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
// add row

$("#addPayment").click(function() {
    var currentCount = $('#inputFormPayment .row').length;
    currentCount += 1;
    console.log(currentCount);
    var html = '';
    html += `
        <div id="inputFormPayment">
            <div class="row">
                <div class="col-8" style="display: inline-block">
                    <label>Payment Description</label>
                    <input type="text" class="form-control m-input" placeholder="Description"
                        name="payment[${currentCount}][description]">
                </div>
                <div class="col-3" style="display: inline-block">
                    <label>Payment Amount</label>
                    <input type="number" step="0.01" class="form-control m-input" placeholder="Amount"
                        name="payment[${currentCount}][amount]">
                </div>

                <div class="col-1" style="padding-top:35px;margin-top:-5px">
                    <button id="removePayment" type="button" class="btn btn-danger">
                    <i class="fas fa-trash-alt"></i>
                    </button>
                </div>
            </div>
        </div>`;

    $('#newPayment').append(html);
});

// remove row
$(document).on('click', '#removeRow', function() {
    $(this).closest('#inputFormRow').remove();
});

$(document).on('click', '#removePayment', function() {
    $(this).closest('#inputFormPayment').remove();
});

$(document).on('change', '#projects', function() {
    console.log(this.value);
    var data = this.value;

    $.ajax({
        data: {
            'project_id': data
        },
        method: "POST",
        url: "{{route('unitReservation')}}",

        success: function(dataResult) {
            var dataResult = JSON.parse(dataResult);
            // console.log(dataResult.units);
            let facilities = "";
            let units = "";
            Array.from(dataResult.facilities).forEach(myFunction);

            function myFunction(item, index) {
                facilities += `
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="form-check">
                                    
                                        <input class="form-check-input" name="facility_id[]" id="test" value="` + item
                    .id + `"
                                            type="checkbox">
                                        <label class="form-check-label">` + item.name + `</label>
                                    </div>
                                </div>
                            </div>
                        </div>`;
            }
            document.getElementById("facilities").innerHTML = facilities;


            Array.from(dataResult.units).forEach(myFunction2);

            function myFunction2(item, index) {
                units += `<option value="` + item.id + `">` + item.name + `</option>`;
            }
            document.getElementById("units").innerHTML = units;
        }
    });
});
</script><!-- /.card -->
@endsection