<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reservation Form</title>
    <!-- <link rel="stylesheet" href="css/style.css"> -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
<style>
    .header{
    display: flex;
    direction: ltr;
}
.header h1{
    text-decoration: underline;
    color: #002060;
    margin-inline-start: 20%;
}
.underlined{
    text-decoration: underline;
}
.header img{
    margin-inline-start: 5%;
}
.margin-start{
    margin-inline-start: 2%;

}
.date span{
    font-weight: 700;
    margin-inline-start: 8%;
}
.individual {
    font-weight: 700;
    margin-inline-start: 22%;
}

table, th, td {
    border: 1px solid black;
    border-collapse: collapse;
  }
  .client-info{
    display: flex;
    justify-content: center;
  }
.client-info-table{
    width: 100%;
}
.unit-info-table{
    width: 50%;
    border: 2px solid black;

}
.payment-info-table{
    width: 100%;
}
.unit-info{
    display: flex;
    justify-content: center;
}
.payment-info{
    margin-inline-start: 2%;
}
.phone-td{
    width: 16%;
    padding: 1%;
    text-align: center;
    background-color: #CCCCFF;
    font-weight: 700;
}
  .full-td{
    width: 23%;
    padding: 1%;
    text-align: center;
    background-color: #CCCCFF;
    font-weight: 700;
}
.full-td-pink{
    width: 20%;
    padding: 1%;
    text-align: center;
    background-color: #FCE4D6;
    font-weight: 700;
}
.empty-td{
    padding:4%;
}
.text-center{
    text-align: center;
}

  .margin-top-5{
    margin-top: 3%;
  }
  .margin-bottom-1{
    margin-bottom: 1%;
  }

  .bold{
    font-weight: 700;
  }

.w-100{
    width: 100%;
}

td{
    text-align:center;
}
.justify-content{
    text-align: justify;
}
.padding-right-51{
    padding-right: 51%;
}
.padding-right-8{
    padding-right: 8%;
}
</style>


</head>
<body dir="rtl" lang="ar">
    <div class="header">
        <img src="{{asset('asset/dist/img/rfco-logo.png')}}" width="200" height="75" alt="">
        <h1 class="underlined">Unit Reservation Form</h1>
    </div>
    <div class="date margin-top-5 margin-bottom-1">
        <span>انه فى يوم: </span>&nbsp; {{$c_day}}
        <span>الموافق: </span>&nbsp; {{$unit->Booked_date}}
    </div>
    <div class="client-info">
        <table class="client-info-table">
            <tr class="margin-bottom-1">
                <td class="full-td">الاسم</td>
                <td>{{ $client->name ?? '-' }}</td>
                <td class="phone-td">الجنسية</td>
                <td>{{ $client->nationality ?? '-' }}</td>

            </tr>
            <tr class="margin-bottom-1">
                <td class="full-td">عنوان الاقامة</td>
                <td>{{ $client->civil_address ?? '-' }}</td>
                <td class="phone-td">المهنة</td>
                <td>{{ $client->job_title ?? '-' }}</td>

            </tr>
            <tr class="margin-bottom-1">
                <td class="full-td">الرقم القومى</td>
                <td>{{ $client->civil_number ?? '-' }}</td>
                <td class="phone-td" >التليفون</td>
                @foreach($client->lead->phone_numbers as $phone)
                <td dir="LTR">{{ $phone->phone ?? '-' }}</td>
                @break
                @endforeach
            </tr>
            <tr class="margin-bottom-1">
                <td class="full-td">البريد الالكترونى</td>
                <td>{{ $client->email ?? '-' }}</td>
            </tr>
        </table>
    </div>
    <div class="unit-info margin-top-5">
        <table class="unit-info-table">
            <tr>
                <th class="full-td">كود الوحدة</th>
                <th class="full-td">الدور</th>
                <th class="full-td">المساحة</th>
            </tr>
            <tr>
                <td class="empty-td">{{ $unit->name ?? '-' }}</td>
                <td class="empty-td">{{ $unit->floor ?? '-' }}</td>
                <td class="empty-td">{{ $unit->unit_space ?? '-' }}</td>
            </tr>
        </table>
    </div>
   
    <ol>
        <li>
            <div class="payment-info margin-top-5">
                <span class="bold">و اقر بالتزامى بالشروط الاتية:.</span>
                <table class="payment-info-table">
                    <tr>
                        <td class="full-td">اجمالى ثمن الوحدة</td>
                        <td>{{ $payment->total_price ?? '-' }}</td>
                        <td class="full-td">مبلغ الصيانة</td>
                        <td  colspan="4">{{ $payment->mentainance ?? '-' }}</td>
        
                    </tr>
                    <tr>
                        <td class="full-td">دفعة الحجز المسددة</td>
                        <td>{{ $payment->reservation ?? '-' }}</td>
                        <td class="full-td">اجمالى قيمة الاقساط</td>
                        <td colspan="4">{{ $payment->batches_amount ?? '-' }}</td>
        
                    </tr>
                    <tr>
                        <td class="full-td">طريقة السداد </td>
                        
                        <td style="text-align:center"><i style="color:green; " class="fas fa-{{$payment->payment_method ==  'cash' ? 'check' : ''}}"></i></td>
                        <td class="full-td-pink" colspan="2">كاش</td>
                        <td style="text-align:center"><i style="color:green;" class="fas fa-{{$payment->payment_method ==  'installment' ? 'check' : ''}}"></i></td>
                        <td class="full-td-pink" colspan="2">تقسيط</td>
                    </tr>
                    <tr>
                        <td class="full-td">نظام سداد الاقسام </td>
                        <td>{{ $payment->batches_payment_duration ?? '-' }}</td>
                        <td class="bold text-center"  colspan="2">سنوات</td>
                        <td class="full-td">عدد الاقساط</td>
                        <td style="width:9%;">{{ $payment->batches_qty ?? '-' }}</td>
                        <td class="bold text-center">قسط</td>
                    </tr>
                </table>
            </div> 
        </li>
        <li>
            <div  class="margin-start">
                <h3 class="underlined bold"> مبلغ هذه الاستمارة غير مسترد</h3>
                <p class="bold justify-content">
                    أتعهد بسدادي كامل دفعه التعاقد والتوقيع على عقد البيع الابتدائى خلال ثلاث أيام من تاريخ هذه الاستماره  وتحرير  شيكات الاقساط اعلاه  كما اتعهد والتزم بسداد الأقساط والدفعات التي حل اجلها ويتم صرف الشيكات المستحقه بتواريخ استحقاقها 							
                </p>
            </div>
        </li>
        <li>
            <div  class="margin-start">
                <p class="bold justify-content">
                    فــى حالــة الغائى للحجز بعد مرور ثلاثه ايام من تاريخ الاستماره  أو إمتنــاعى عن توقيع عقد البيع أو تحرير شيكات الأقساط أو سداد باقى المقدم او أى قسط من الأقساط  في الموعد المحدد بالبند السابق يعتبر ذلك عدولا نهائيا عن حجزى للوحده/ للوحدات وتعتبر هذه الاستمارة لاغيه  كأن لم تكن  - واقر بحق الشركة في بيع الوحدة للغير دون الاعتداد بهذا الحجز ودون الحاجه الى تنبيه او انذار  او استصدار حكم قضائى بذلك 								
                </p>
            </div>
        </li>
        <li>
            <div  class="margin-start">
                <p class="bold justify-content">
                    أقر بأن عنوان مراسلاتى داخل مصر هو العنوان المختار الذى يصح عليه قانوناً إخطارى بأية إخطارات أو إعلانات وأتعهد بإخطــار الشـركة رسمياً  فى حالة تغييره وإلا تصح جميع المراسلات عليه وبشرط ان يكون العنوان الجديد داخل مصر .								
								
                </p>
            </div>
        </li>
    </ol>
    <div class=" margin-top-5 margin-bottom-1">
        <span class="padding-right-8 bold">الاسم:</span>
        <span class="padding-right-51 bold">التاريخ</span>
    </div>
    <div class="date margin-bottom-1">
        <br>
        <span>التوقيع</span>
        <br>
        <br>
    </div>
    <div class=" margin-bottom-1 margin-top-5">
        <span class="bold margin-start">مسئول المبيعات</span>
        <span class="individual">المدير المسئول</span>
        <span class="individual">ادارة الحسابات</span>


    </div>

     
</body>
<script src="https://kit.fontawesome.com/yourcode.js" crossorigin="anonymous"></script>

<script>
window.print();
</script>
</html>