@extends ('../welcome')
@section('content')

    <div class="card card-default">
        <form action="{{ route('communications.store') }}" method="POST">
            <div class="card-header">
                Call Action
            </div>
            <div class="card-body">

                @csrf
                <div class="row">
                    <div class="col-md-6">

                        <div class="form-group">
                            @if (empty($leadData))
                                <div class="row">
                                    <label for="lead_id" class="col-3">Lead: </label>
                                    <select name="lead_id" class="select2 custom-select form-control-border col-6"
                                        id="lead_id">
                                        @foreach ($leads as $lead)
                                            <option value="{{ $lead->id }}">{{ $lead->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            @else
                                <div class="form-group mb-3">
                                    <div class="row">
                                        <label class="col-3">Lead: </label>
                                        <input class="form-control col-6" value="{{ $leadData->name }}" disabled>
                                    </div>
                                </div>
                                <input type="hidden" name="lead_id" value="{{ $leadData->id }}">
                            @endif
                        </div>
                        <input type="hidden" name="status_id" value="{{ $leadData->status_id }}">

                        <div class="form-group">
                            <div class="row">
                                <div class="col-3"></div>
                                <input class="action" id="answer" type="radio" name="action" value="answer">
                                <label for="answer" class="col-3">answer</label>

                                <input id="no-answer" class="action" type="radio" name="action" value="no-answer">
                                <label for="no-answer" class="col-3">no-answer</label>
                            </div>
                        </div>
                        <div class="form-group mb-3">
                            <div class="row">
                                <label class="col-3">Call Action Type: </label>
                                <select name="call_action_id" class="select2 custom-select form-control-border col-6"
                                    id="actionTypes">

                                </select>
                            </div>
                        </div>

                        <div class="form-group mb-3">
                            <div class="row">
                                <label for="meeting-time" class="col-3">Next Action time:</label>
                                <input type="datetime-local" class="form-control col-6" id="meeting-time"
                                    value="{{ date('Y-m-d H:i:s') }}" name="start_date" min="{{ date('Y-m-d H:i:s') }}">
                            </div>
                        </div>

                    </div>
                    <div class="col-md-6">

                        <div class="form-group mb-3">
                            <textarea type="text" class="form-control" rows="8" cols="30" placeholder="Type Action Details..."
                                name="description"></textarea>
                        </div>

                    </div>
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
            </div>
        </form>
    </div>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(document).ready(function() {
            function myFunction() {
                var dt = new Date();
                return dt;
            }
        });

        $(document).on('change', '.action', function() {
            // console.log(this.value);
            var data = this.value;

            $.ajax({
                data: {
                    'action': data
                },
                method: "POST",
                url: "{{ route('actionTypes') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    // console.log(dataResult.actionTypes);
                    let actionTypes = "";


                    Array.from(dataResult.actionTypes).forEach(myFunction2);

                    function myFunction2(item, index) {
                        actionTypes += `<option value="` + item.id + `">` + item.name + `</option>`;
                    }
                    document.getElementById("actionTypes").innerHTML = actionTypes;
                }
            });
        });
    </script>
@endsection
