@extends ('../welcome')

@section ('content')

<div class="card-info" style="padding:5px;">
    <div class="card-header">
        <h3 class="card-title">Create payment</h3><br>
        <h3 class="card-title">Client Name: {{$unit->client->name}}</h3>
    </div>
    <br>
    <form action="{{ route('payments.store') }}" method="post">
        @csrf
        <input type="hidden" name="unit_id" value="{{$unit->id}}">
        <input type="hidden" name="client_id" value="{{$unit->client->id}}">
        <div class="row">
            <div class="form-group col-3">
                <label>Unit Name</label>
                <input type="text" class="form-control" value="{{$unit->name}}" disabled>
            </div>
            <div class="col-3 mb-3" style="display: inline-block;">
                <label for="status">Status</label>
                <select name="status" class="select2 custom-select form-control-border">
                    <!-- <option value="hold">hold</option> -->
                    <option value="reserved">reserved</option>
                    <option value="downpayment">downpayment</option>
                    <option value="taken">taken</option>

                </select>
            </div>
        </div>
        <br>
        <div id="inputFormPayment" style="margin-left: 9px;">
            <div class="row">
                <div class="col-3" style="display: inline-block">
                    <label>Payment Description</label>
                    <input type="text" class="form-control m-input" placeholder="Description"
                        name="payment[0][description]" required>
                </div>
                <div class="col-3" style="display: inline-block">
                    <label>Payment Amount</label>
                    <input type="number" class="form-control m-input" placeholder="Amount" name="payment[0][amount]"
                        required>
                </div>
                <button id="addPayment" type="button" class="btn btn-info" style="margin-top:33px">
                    <i class="fa fa-plus" aria-hidden="true"></i>
                </button>
            </div>
            <div id="newPayment"></div>
        </div>
</div>
<br>
<div class="col-6" style="float:right;">
    <button type="submit" class="btn btn-primary">Submit</button>
</div>
</form>

<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
$("#addPayment").click(function() {
    var currentCount = $('#inputFormPayment .row').length;
    currentCount += 1;
    console.log(currentCount);
    var html = '';
    html += `
        <div id="inputFormPayment">
            <div class="row">
                <div class="col-3" style="display: inline-block">
                    <label>Payment Description</label>
                    <input type="text" class="form-control m-input" placeholder="Description"
                        name="payment[${currentCount}][description]">
                </div>
                <div class="col-3" style="display: inline-block">
                    <label>Payment Amount</label>
                    <input type="number" class="form-control m-input" placeholder="Amount"
                        name="payment[${currentCount}][amount]">
                </div>

                <div class="col-2" style="padding-top:35px;margin-top:-15px">
                    <button id="removePayment" type="button" class="btn btn-danger">
                    <i class="fas fa-trash-alt"></i>
                    </button>
                </div>
            </div>
        </div>`;

    $('#newPayment').append(html);
});

// remove row

$(document).on('click', '#removePayment', function() {
    $(this).closest('#inputFormPayment').remove();
});
</script><!-- /.card -->
@endsection