@extends ('../welcome')


@section('content')
    <!-- Filters -->
    <style>
        .description-block {
            background-color: #161616d4;
            position: absolute;
            bottom: 1px;
            left: 55px;
            padding: 14px 0px;
            width: 75%;
        }

        .ribbon {
            background-color: #212529;

        }
    </style>

    <div class="card-header">

        @if (auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('projects-restoreAll'))
            <a href="{{ route('projects.restoreAll') }}" style="float:right">
                <button class="btn btn-square btn-outline-success" type="button"><i
                        class="fas fa-trash-restore-alt"></i></button>
            </a>
        @endif

        <p>Total: {{ count($projects) }}</p>

    </div>
    <div class='row'>
        @foreach ($projects as $project)
            <div class="col-md-4">
                <a class="text-decoration-none text-white" href="{{ route('projects.show', $project->id) }}">
                    <!-- Widget: user widget style 1 -->
                    <div class="card card-widget shadow-lg">
                        <!-- Add the bg color to the header using any of the bg-* classes -->
                        <div class="widget-user-header">
                            <img width="460" height="260" src="{{ URL::to('/') }}/images/{{ $project->logo }}"
                                alt="{{ $project->logo }}">
                            <h5 class="widget-user-desc text-right text-white">{{ $project->name }}</h5>

                            <div class="ribbon-wrapper ribbon-xl">
                                <div class="ribbon text-xl">
                                    Archived
                                </div>
                            </div>
                        </div>

                        <div class="card-footer">

                            <div class="col-sm-12">
                                <div class="description-block rounded">
                                    <h4>{{ $project->name }}</h4>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('projects-restore'))
                                        <a class="btn btn-outline-light" title="Restore"
                                            href="{{ route('project.restore', $project->id) }}">
                                            <i class="fas fa-trash-restore-alt"></i>
                                        </a>

                                        @if (auth()->user()->role->hasPermission('delete-permanently'))
                                            <a href="{{ route('project.deletePermanently', $project->id) }}">
                                                <button title="Delete" class="btn btn-danger">
                                                    <i class="fa fa-ban"></i>
                                                </button>
                                            </a>
                                        @endif
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </a>
            </div>
        @endforeach
    </div>
@endsection
