@extends ('../welcome')

@section('content')
<style>
ul,
#tree1 {
    list-style-type: none;
}

#tree1 {
    margin: 0;
    padding: 0;
}

.caret {
    cursor: pointer;
    -webkit-user-select: none;
    /* Safari 3.1+ */
    -moz-user-select: none;
    /* Firefox 2+ */
    -ms-user-select: none;
    /* IE 10+ */
    user-select: none;
}

.caret::before {
    content: "\25B6";
    color: black;
    display: inline-block;
    margin-right: 6px;
}

.caret-down::before {
    -ms-transform: rotate(90deg);
    /* IE 9 */
    -webkit-transform: rotate(90deg);
    /* Safari */
    '
transform: rotate(90deg);
}

.nested {
    display: none;
}

.active {
    display: block;
}

.form-show {
    display: block;
}

.form-hide {
    display: none;
}
</style>

<body>
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-4 ml-4">
                    <div class="tree-show">
                        <ul id="tree1">
                            @foreach ($allRoles->where('role_id', null) as $role)
                            
                            <li><span class="caret"><span class="node {{ $role->id }}"
                                        data-id="{{ $role->id }}">{{ $role->name }}
                                    </span></span>
                                   @if (count($role->childs) != 0)
                                   @include('roles.manageChild', ['childs' => $role->childs])
                                   @endif
                            </li>

                            @endforeach

                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
    var toggler = document.getElementsByClassName("caret");
    var i;

    for (i = 0; i < toggler.length; i++) {
        toggler[i].addEventListener("click", function() {
            this.parentElement.querySelector(".nested").classList.toggle("active");
            this.classList.toggle("caret-down");
        });
    }
    </script>
    @endsection
