@extends ('../welcome')


@section ('content')
<div class="card col-6">
    <div class="card-body register-card-body">
        <p class="login-box-msg">Add New Source</p>
        <form action="{{ route('sources.store') }}" method="POST">
            @csrf
            <div class="form-group mb-3 row">
                <label class="col-5">Name: </label>
                <input type="text" name="name" value="{{old('name')}}" class="form-control col-4" required>
            </div>
            
            <div class="form-group mb-3 row">
                <label class="col-5">Campaigns: </label>
                <select name="campaign_id" class="select2 custom-select form-control-border col-4" id="campaign" required>
                    <option value=""></option>
                    @forelse($campaigns as $campaign)
                    <option value="{{$campaign->id}}">{{$campaign->name}}</option>
                    @empty
                    @endforelse
                </select>
            </div>

            <div class="form-group mb-3 row">
                <label class="col-5">Source Types: </label>
                <select name="sourceType_id" class="select2 custom-select form-control-border col-4" id="sourceType" required>
                    <option value=""></option>
                    @forelse($sourceTypes as $sourceType)
                    <option value="{{$sourceType->id}}">{{$sourceType->name}}</option>
                    @empty
                    @endforelse
                </select>
            </div>

            <div class="form-group mb-3 row">
                <label class="col-5">Projects: </label>
                <select name="project_id" class="select2 custom-select form-control-border col-4" id="project" required>
                    <option value=""></option>
                    @forelse($projects as $project)
                    <option value="{{$project->id}}">{{$project->name}}</option>
                    @empty
                    @endforelse
                </select>
            </div>
            <div style="float:right;">
                <button type="submit" class="btn btn-info">Submit</button>
            </div>
        </form>
    </div>
</div>

<script>
$("#startDate").change(function() {
    const date = new Date();

    let day = date.getDate();
    let month = date.getMonth() + 1;
    let year = date.getFullYear();
    let currentDate = `${year}-${month}-${day}`;

    
    console.log(currentDate);
    console.log(this.value);
});
</script>
@endsection