

<?php $__env->startSection('content'); ?>
    
    <div class="card card-info card-outline collapsed-card col-12">
        <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
            <div class="card-title">
                Filter
            </div>
        </div>
        <div class="card-body">
            <form>
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>phases</label>

                            <select name="phase_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($phase->id); ?>" <?php echo e(isset(Request::get('phase_id')[0]) && in_array($phase->id, Request::get('phase_id')) ? 'selected' : ''); ?>><?php echo e($phase->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label>Projects</label>

                            <select name="project_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($project->id); ?>"<?php echo e(isset(Request::get('project_id')[0]) && in_array($project->id, Request::get('project_id')) ? 'selected' : ''); ?>><?php echo e($project->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" value="<?php echo e($_GET['time1'] ?? ''); ?>" class="form-control"
                                    name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>to</label>

                                <input type="time" name="time2" value="<?php echo e($_GET['time2'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="<?php echo e($_GET['date1'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="<?php echo e($_GET['date2'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                        </div>

                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:left">filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
    
    
    <!-- Phases -->
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">Phases</h3><br>
                <p>Total: <?php echo e($phases->total()); ?></p>

                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('phases-archive')): ?>
                    <a href="<?php echo e(route('phasesArchive')); ?>" style="float:right">
                        <button class="btn btn-outline-success" title="Archive" type="button"><i
                                class="fas fa-archive"></i></button>
                    </a>
                <?php endif; ?>

            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table
                    id=<?php echo e(auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('phases-export')? 'example1': 'nonExport'); ?>

                    class="table table-bordered" style="margin: unset">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Phase Name</th>
                            <th>Project Name</th>
                            <th>Created Date</th>
                            <th>Created Time</th>

                            <?php if(auth()->user()->type == 'admin'): ?>
                                <th>Active</th>
                            <?php endif; ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $phase->created_at->setTimezone('Africa/Cairo')); ?>

                            <?php if(!empty($phase->project->id)): ?>
                                <tr>
                                    <td><?php echo e($phase->id); ?></td>
                                    <td>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('phases-show')): ?>
                                            <a href="<?php echo e(route('phases.show', $phase->id)); ?>">
                                                <?php echo e($phase->name); ?>

                                            </a>
                                        <?php else: ?>
                                            <a>
                                                <?php echo e($phase->name); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('projects-show')): ?>
                                            <a href="<?php echo e(route('projects.show', $phase->project->id)); ?>">
                                                <?php echo e($phase->project->name); ?>

                                            </a>
                                        <?php else: ?>
                                            <a>
                                                <?php echo e($phase->project->name); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e($temp[0]); ?></td>
                                    <td><?php echo e($temp[1]); ?></td>
                                    <td>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('phases-hide')): ?>
                                            <form action="<?php echo e(route('hidePhase', $phase->id)); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <button type="submit"
                                                    class="btn btn-<?php echo e($phase->is_active == 0 ? 'info' : 'danger'); ?>"
                                                    title="<?php echo e($phase->is_active == 0 ? 'unhide' : 'hide'); ?>">
                                                    <?php echo e($phase->is_active == 0 ? 'unhide' : 'hide'); ?>

                                                </button>
                                            </form>
                                        <?php endif; ?>
                                    </td>

                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
                <div class="pagination">
                    <?php echo e($phases->appends(request()->input())->links()); ?>

                </div>

            </div>
            <!-- /.card-body -->
        </div>
    </div>
    <!-- /.row -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/phases/index.blade.php ENDPATH**/ ?>