


<?php $__env->startSection('content'); ?>

    <div class="card col-12">
        <div class="card-header">
            <h4 class="card-title"><strong>Users</strong></h4>
            <br>
            <lable><span style="font-size:18px;font-weight:bold">Total: </span> <?php echo e(count($UserChildren)); ?></lable>
            <div style="float:right;">
                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('users-create')): ?>
                    <a href="<?php echo e(route('addUser')); ?>" title="Create user" class="btn btn-light active"><i
                            class="fa fa-plus"></i></a>
                <?php endif; ?>
                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('users-tree')): ?>
                    <a href="<?php echo e(route('usersTree')); ?>" title="view tree" class="btn btn-success"><i
                            class="fa fa-tree"></i></a>
                <?php endif; ?>

                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('users-blocklist')): ?>
                    <a href="<?php echo e(route('blocklist')); ?>" title="Block List" class="btn btn-danger"><i
                            class="fa fa-user-lock"></i></a>
                <?php endif; ?>

            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table class="table table-bordered" id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('users-export') ? 'example1' : 'nonExport'); ?> 
                >
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone Numbers</th>
                        <th style="text-align:center;">Role</th>
                        <th style="text-align:center;">Leader</th>
                        <th>Created at</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>

                    <?php if(auth()->user()->type == 'admin'): ?>
                        <?php $__empty_1 = true; $__currentLoopData = $UserChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class='clickable-row' data-href='<?php echo e(route('users.show', $user->id)); ?>'>
                                <td><?php echo e($user->id); ?></td>
                                <td>
                                    <?php echo e($user->name ?? ''); ?>

                                </td>
                                <td><?php echo e($user->email ?? ''); ?></td>

                                <td>
                                    <?php $__currentLoopData = $user->phones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php echo e($phone->country->name ?? ''); ?> - <?php echo e($phone->phone ?? ''); ?>

                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </td>
                                <td><?php echo e($user->role?->name ?? ''); ?></td>
                                <td><?php echo e($user->parent?->name ?? ''); ?></td>
                                <td><?php echo e($user->created_at); ?></td>
                                <td>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-edit')): ?>
                                        <a class="btn btn-info" title="Edit" href="<?php echo e(route('users.edit', $user->id)); ?>">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-block')): ?>
                                        <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                            class="btn btn-danger" data-id="<?php echo e($user->id); ?>" data-toggle="modal"
                                            data-target="#exampleModalCenter">
                                            <i class="fa fa-ban"></i>
                                        </button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                    <?php else: ?>
                        <?php for($i = 0; $i < count($UserChildren); $i++): ?>
                            <option value="<?php echo e($UserChildren[$i]['id']); ?>">
                                <tr class='clickable-row' data-href='<?php echo e(route('users.show', $UserChildren[$i]['id'])); ?>'>
                                    <td><?php echo e($UserChildren[$i]['id']); ?></td>
                                    <td>
                                        <?php echo e($UserChildren[$i]['name'] ?? ''); ?>

                                    </td>
                                    <td><?php echo e($UserChildren[$i]['email'] ?? ''); ?></td>
                                    <td><?php echo e($UserChildren[$i]['created_at'] ?? ''); ?></td>
                                    <td>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-edit')): ?>
                                            <a class="btn btn-info" title="Edit"
                                                href="<?php echo e(route('users.edit', $UserChildren[$i]['id'])); ?>">
                                                <i class="fa fa-pen"></i>
                                            </a>
                                        <?php endif; ?>
                                        <?php if(auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-block')): ?>
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="<?php echo e($user->id); ?>" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            </option>
                        <?php endfor; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    <!-- Archive Lead Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Archive User</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to Archive this User ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('users.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/users/index.blade.php ENDPATH**/ ?>