


<?php $__env->startSection('content'); ?>

<style>
    #upload-photo {
        display: none;
    }

    .pagination nav .relative.z-0.inline-flex {
        display: inline-flex;
    }

    .pagination nav .hidden {
        display: unset !important;
    }

    .pagination nav .flex-1.justify-between {
        padding: 15px 0
    }

    .pagination nav .flex.justify-between.flex-1 {
        display: none
    }
</style>
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">Sources</div>
                <?php if(auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('sources-create')): ?>
                    <a href="<?php echo e(route('sources.create')); ?>">
                        <button class="btn btn-square btn-light active" type="button" style="float:left; margin-left:20px;"><i
                                class="fas fa-plus"></i></button>
                    </a>
                <?php endif; ?>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="card-title">Total: <?php echo e(count($allSources)); ?></div>
            </div>
            <div class="card-body">
                <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('sources-export') ? 'example1' : 'nonExport'); ?> 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Project</th>
                            <th>SourceType</th>
                            <th>Campaign</th>
                            <th>Created Date</th>
                            <th>Created Time</th>

                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $sources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $source->created_at); ?>

                            <tr>
                                <td><?php echo e($source->id); ?></td>
                                <td><?php echo e($source->name); ?></td>
                                <td><?php echo e($source->project?->name); ?></td>
                                <td><?php echo e($source->sourceType?->name); ?></td>
                                <td><?php echo e($source->campaign?->name ?? ''); ?></td>
                                <td><?php echo e($temp[0]); ?></td>
                                <td><?php echo e($temp[1]); ?></td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('sources-edit')): ?>
                                        <a class="btn btn-primary" title="Edit"
                                            href="<?php echo e(route('sources.edit', $source->id)); ?>">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('sources-show')): ?>
                                        <a class="btn btn-warning" title="Show"
                                            href="<?php echo e(route('sources.show', $source->id)); ?>">
                                            <i class="fa fa-eye"></i>
                                        </a>
                                    <?php endif; ?>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('campaigns-delete')): ?>
                                        <?php if(count($source->leads) == 0): ?>
                                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                                data-id="<?php echo e($source->id); ?>" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
                <div class="pagination">
                    <?php echo e($sources->appends(request()->input())->links()); ?>

                </div>
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalCenter" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Delete Record</h5>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure to delete this record ?</p>
                            </div>
                            <form class="modal-footer" method="post">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.row -->
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('sources.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        function updateTextInput(val) {
            document.getElementById('textInput').value = val;
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/sources/index.blade.php ENDPATH**/ ?>