


<?php $__env->startSection('content'); ?>
    <style>
        #upload-photo {
            display: none;
        }

        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>

    <!-- Filters -->
    <div class="card card-info collapsed-card">
        <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
            <div class="card-title">
                Filter
            </div>
        </div>
        <div class="card-body">
            <form>
                <div class="row">
                    <div class="col-6">
                        <div class="form-group">
                            <label>Buildings</label>

                            <select name="building_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $Allbuildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($building->id); ?>" <?php echo e(isset(Request::get('building_id')[0]) && in_array($building->id, Request::get('building_id')) ? 'selected' : ''); ?>><?php echo e($building->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="form-group">
                            <label>phases</label>

                            <select name="phase_id[]" class="select2 custom-select form-control-border" multiple>
                                <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($phase->id); ?>"><?php echo e($phase->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    

                    <div class="col-6">
                        <div class="row">
                            <div class="form-group col-6">
                                <label>From</label>
                                <input type="time" value="<?php echo e($_GET['time1'] ?? ''); ?>" class="form-control"
                                    name="time1">
                            </div>
                            <div class="form-group col-6">
                                <label>to</label>

                                <input type="time" name="time2" value="<?php echo e($_GET['time2'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                        </div>
                        <div class="row">
                            <div class="form-group col-6">
                                <input type="date" name="date1" value="<?php echo e($_GET['date1'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                            <div class="form-group col-6">
                                <input type="date" name="date2" value="<?php echo e($_GET['date2'] ?? ''); ?>"
                                    class="form-control">
                            </div>
                        </div>

                        <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default">Back</a>
                        <button type="submit" class="btn btn-info" style="float:left">filter</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Buildings</h3>
            <?php if(auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('buildings-archive')): ?>
                <a href="<?php echo e(route('buildingsArchive')); ?>" style="float:right">
                    <button class="btn btn-outline-success" title="Archive" type="button">
                        <i class="fas fa-archive"></i>
                    </button>
                </a>
            <?php endif; ?>

        </div>
        <div class="card-body">
            <p>Total: <?php echo e($Allbuildings->total()); ?></p>
            <table
                id=<?php echo e(auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('buildings-export')? 'example1': 'nonExport'); ?>

                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Phase Name</th>
                        <th>Project Name</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        <th>Active</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $Allbuildings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $building): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $temp = explode(' ', $building->created_at);
                        ?>
                        <tr>
                            <td><?php echo e($building?->id); ?></td>
                            <td>
                                <a href="<?php echo e(route('buildings.show', $building->id)); ?>">
                                    <?php echo e($building->name); ?>

                                </a>
                            </td>
                            <td>
                                <?php if($building->phase?->id): ?>
                                    <a href="<?php echo e(route('phases.show', $building->phase->id)); ?>">
                                        <?php echo e($building->phase->name); ?>

                                    </a>
                                <?php endif; ?>
                            </td>
                            <td>
                                <?php if($building->phase->project): ?>
                                    <a href="<?php echo e(route('projects.show', $building->phase->project->id)); ?>">
                                        <?php echo e($building->phase->project->name); ?>

                                    </a>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($temp[0]); ?></td>
                            <td><?php echo e($temp[1]); ?></td>

                            <td>
                                <form action="<?php echo e(route('hideBuilding', $building->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('buildings-hide')): ?>
                                        <button type="submit"
                                            class="btn btn-<?php echo e($building->is_active == 0 ? 'info' : 'danger'); ?>"
                                            title="<?php echo e($building->is_active == 0 ? 'unhide' : 'hide'); ?>">
                                            <?php echo e($building->is_active == 0 ? 'unhide' : 'hide'); ?>

                                        </button>
                                    <?php endif; ?>
                                </form>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <div class="pagination">
                <?php echo e($Allbuildings->appends(request()->input())->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/buildings/index.blade.php ENDPATH**/ ?>