
<?php $__env->startSection('content'); ?>
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
    </style>

    <!-- Filters -->
    <form>
        <div class="card card-info  collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div id="left side" class="col-6">
                        

                        <table id="Other filters" style="width:85%">
                            <tr>
                                <th style="width:25%" title="Ticket Status">Status: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple
                                        name="ticket_status[]">
                                        <option>pending</option>
                                        <option>follow_up</option>
                                        <option>done</option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Ticket Type">Type: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple
                                        name="ticketType_id[]">
                                        <?php $__currentLoopData = $ticketTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Units: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="unit_id[]">
                                        <?php $__currentLoopData = $units; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($unit->id); ?>"><?php echo e($unit->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%">Clients: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="client_id[]">
                                        <?php $__currentLoopData = $clients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $client): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($client->id); ?>"><?php echo e($client->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Communication Method">Methods: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="method_id[]">
                                        <?php $__currentLoopData = $methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($method->id); ?>"><?php echo e($method->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th style="width:25%" title="Assigned User">User: </th>
                                <td class="form-group">
                                    <select class="select2 custom-select form-control-border" multiple name="user_id[]">
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div id="right side" class="col-6">
                        <table id="created_at">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Creation Date</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="date1" class="form-control">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="date2" class="form-control">
                                </td>
                            </tr>
                        </table>
                        <hr>
                        <br>
                        <table id="call_date">
                            <tr colispan>
                                <th colspan="4" style="text-align:center">Call Date</th>
                            </tr>
                            <tr>
                                <th>From</th>
                                <td class="form-group">
                                    <input type="date" name="call_date1" class="form-control">
                                </td>
                                <th>To</th>
                                <td class="form-group">
                                    <input type="date" name="call_date2" class="form-control">
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <div class="card-footer" style="text-align:right">
                <button type="submit" class="btn btn-info">filter</button>
                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-default">Back</a>
            </div>
        </div>
    </form>

    <!-- Content -->
    <div class="card">
        <div class="card-header">
            <div class="card-title">Tickets <br> Total: <?php echo e($tickets->total()); ?></div>
            <?php if(auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('tickets-create')): ?>
                <a href="<?php echo e(route('tickets.create')); ?>">
                    <button class="btn btn-square btn-outline-info" type="button" style="float:right">
                        <i class="fas fa-plus"></i>
                    </button>
                </a>
            <?php endif; ?>
        </div>
        <!-- /.card-header -->

        <div class="card-body">
            <table
                id=<?php echo e(auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('tickets-export')? 'example1': 'nonExport'); ?>

                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Ticket ID</th>
                        <th>Ticket Status</th>
                        <th>Client Name</th>
                        <th>Phone</th>
                        <th>Ticket Type</th>
                        <th>Related Item</th>
                        <th>Ticket Source</th>
                        <th>Note</th>
                        <th>Call Date</th>
                        <th>Ticket Creation Date</th>
                        
                        <th>Created By</th>
                        <th>Assigned User</th>

                        <th>Show</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <a href="<?php echo e(route('tickets.show', $ticket->id)); ?>">
                                    <?php echo e($ticket->id ?? ''); ?>

                                </a>
                            </td>
                            <td><?php echo e($ticket->status ?? ''); ?></td>
                            <td>
                                <a href="<?php echo e(route('clients.show', $ticket->client?->id)); ?>">
                                    <?php echo e($ticket->client?->name ?? ''); ?>

                                </a>
                            </td>

                            <td>
                                <?php if(!empty($ticket->client->phone_numbers)): ?>
                                    <?php $__currentLoopData = $ticket->client->phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <?php echo e($phone->country->phonecode); ?> <?php echo e($phone->phone); ?>

                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </td>
                            <td><?php echo e($ticket->ticket_type?->name ?? ''); ?></td>

                            <td>
                                <a href="<?php echo e(route('units.show', $ticket->unit?->id)); ?>">
                                    <?php echo e($ticket->unit?->name ?? ''); ?>

                                </a>
                            </td>
                            <td><?php echo e($ticket->method?->name ?? ''); ?></td>
                            <td><?php echo e($ticket->description ?? ''); ?></td>
                            <td>
                                <?php echo e(Carbon\Carbon::parse($ticket->call_date)->format('Y-m-d') ?? ''); ?>

                            </td>
                            <td><?php echo e($ticket->created_at ?? ''); ?></td>
                            <td>
                                <a href="<?php echo e(route('users.show', $ticket->ticket_created_by?->id)); ?>">
                                    <?php echo e($ticket->ticket_created_by?->name); ?>

                                </a>
                            </td>
                            <td>
                                <a href="<?php echo e(route('users.show', $ticket->assigned_to?->id)); ?>">
                                    <?php echo e($ticket->assigned_to?->name ?? ''); ?>

                                </a>
                            </td>
                            <td>
                                <?php if(auth()->user()->type == 'admin' || Auth::user()->role->hasPermission('tickets-show')): ?>
                                    <a class="btn btn-info" href="<?php echo e(route('tickets.show', $ticket->id)); ?>">Show</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\Nesma\Work\peacode\CRM\resources\views/tickets/index.blade.php ENDPATH**/ ?>