<?php

namespace App\Http\Controllers\Administration;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Exception;
use App\Models\Campaign;
use App\Models\Project;
use App\Http\Requests\CampaignRequest;

class CampaignController extends Controller
{
    // public function __construct()
    // {
    //     $this->middleware('permission:campaigns-create',['only' => ['create', 'store']]);
    //     $this->middleware('permission:campaigns-read',['only' => ['show']]);
    //     $this->middleware('permission:campaigns-update',['only' => ['edit', 'update']]);
    //     $this->middleware('permission:campaigns-delete',['only' => ['destroy']]);
    // }

    public function index(Request $request)
    {
        activity()
                ->event('visit')
                ->log(auth()->user()->name .' viewed campaigns index');
                
        $campaigns =  Campaign::query();
        if($request->project_id){
            $campaigns = Campaign::whereIn('project_id',$request->project_id);
        }
        if($request->campaign_id){
            $campaigns = Campaign::whereIn('id',$request->campaign_id);
        }
        if($request->time1 && $request->time2){
            $campaigns->whereTime('created_at', '>=',$request->time1)
            ->whereTime('created_at','<=',$request->time2);
        }
        
        if($request->date1 && $request->date2){
            $campaigns->whereDate('created_at', '>=',$request->date1)
            ->whereDate('created_at','<=',$request->date2);
        }

        if($request->budget1 && $request->budget2){
            $campaigns->where('budget', '>=',$request->budget1)->where('budget','<=',$request->budget2);
        }

        if($request->status){
            $campaigns = Campaign::where('status',$request->status);
        }

        $campaigns = $campaigns->paginate(100)->withQueryString();

        // $campaigns= $campaigns->get();
        $projects = Project::all();        
        $allCampaigns= Campaign::get();


        return view('campaigns.index',compact('campaigns', 'projects','allCampaigns'));
    }

    public function create()
    {
        activity()
                ->event('visit')
                ->log(auth()->user()->name .' viewed campaigns creation page');
        $projects = Project::where('is_active',1)->get();
        return view('campaigns.create', compact('projects'));
    }

    public function store(CampaignRequest $request)
    {
        try
        {
            DB::beginTransaction();
            $campaign = new Campaign();
            $campaign->name = $request->name;
            $campaign->description = $request->description;
            $campaign->status = $request->status;
            $campaign->start_date = $request->start_date;
            $campaign->end_date = $request->end_date;
            $campaign->budget = $request->budget;
            $campaign->target = $request->target;
            $campaign->purpose = $request->purpose;
            // $campaign->type = $request->type;
            $campaign->project_id = $request->project_id ? $request->project_id : Null;
            $campaign->save();
            DB::commit(); 
            activity()
                ->event('create')
                ->log(auth()->user()->name .'created campaign: ' . $campaign->name);

            return redirect()->route('campaigns.index')->with('success','Campaign Created Successfully');
        }
        catch(Exception $e){
            return redirect()->back()->with('error',$e->getMessage());
        }
    }

    public function edit($campaignId)
    {
        $campaign = Campaign::findOrFail($campaignId);

        activity()
                ->event('visit')
                ->log(auth()->user()->name .' viewed campaign: ' . $campaign->name . ' edit page');
        $projects = Project::where('is_active',1)->get();
        return view('campaigns.edit',compact('campaign', 'projects'));
    }

    public function update($campaignId, CampaignRequest $request)
    {
        $campaign = Campaign::findOrFail($campaignId);
        try
        {
            DB::beginTransaction();
            $campaign->name = $request->name;
            $campaign->description = $request->description;
            $campaign->status = $request->status;
            $campaign->start_date = $request->start_date;
            $campaign->end_date = $request->end_date;
            $campaign->budget = $request->budget;
            $campaign->target = $request->target;
            $campaign->purpose = $request->purpose;
            // $campaign->type = $request->type;
            $campaign->project_id = $request->project_id ? $request->project_id : Null;
            $campaign->save();
            DB::commit();
            activity()
                ->event('update')
                ->log(auth()->user()->name .' updated campaign: ' . $campaign->name);
            return redirect()->route('campaigns.index')->with('success','Campaign Updated Successfully');
        }
        catch(Exception $e){
            return redirect()->back()->with('error',$e->getMessage());
        }

    }

    public function show($campaignId)
    {
        $campaign = Campaign::findOrFail($campaignId);

        activity()
                ->event('visit')
                ->log(auth()->user()->name .' viewed campaign: ' . $campaign->name . ' page');
        return view('campaigns.show',compact('campaign'));
    }

    public function destroy($campaignId)
    {
        $campaign = Campaign::findOrFail($campaignId);
        activity()
        ->event('delete')
        ->log(auth()->user()->name .' deleted campaign: ' . $campaign->name);
        $campaign->delete();
        return redirect()->route('campaigns.index')->with('success','Campaign Deleted Successfully');

    }
}