<?php

namespace App\Http\Controllers;

use App\Models\Status;
use App\Models\CallAction;
use Illuminate\Http\Request;

class StatusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response 
     */
    public function index()
    {
        //
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $statuses = Status::get();
        return view('statuses.create', compact('statuses'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $statuses = Status::pluck('name');
    
        $fCount = count($statuses);
        $rCount = count($request->name);

        if($rCount >= $fCount){ 
            for ($i=0; $i<$rCount; $i++) {
                Status::updateOrCreate(
                    [
                        'name' => $request->name[$i],
                    ],
                    [
                        'type' => $request->callAction_type[$i],
                        'color' => $request->color[$i]
                    ],
                );
            }
        }

        $action_statuses = CallAction::pluck('name');
    
        $fCount = count($action_statuses);
        $rCount = count($request->name);

        if($rCount >= $fCount){ 
            for ($i=0; $i<$rCount; $i++) {
                CallAction::updateOrCreate(
                    [
                        'name' => $request->name[$i],
                    ],
                    [
                        'type' => $request->callAction_type[$i],
                    ],
                );
            }
        }
         $user = auth()->user();
         activity()
         ->event('update Statuses')
         ->log($user->name .' updated Statuses');
        return redirect()->back()->with('success', 'Statuses updated Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Status  $status
     * @return \Illuminate\Http\Response
     */
    public function show(Status $status)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Status  $status
     * @return \Illuminate\Http\Response
     */
    public function edit(Status $status)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Status  $status
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Status $status)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Status  $status
     * @return \Illuminate\Http\Response
     */
    public function destroy(Status $status)
    {
        //
        $callAction = CallAction::where('name', $status->name)->first();
        $callAction->delete();
        $status->delete();
        return redirect()->back()->with('success', 'Status Trashed Successfully');
    }
}
