<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Communication extends Model
{
    use HasFactory;

    protected $fillable = ['description','lead_id','user_id','call_action_id','created_by'];

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }
    public function broker()
    {
        return $this->belongsTo(Broker::class, 'broker_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function callAction()
    {
        return $this->belongsTo(CallAction::class, 'call_action_id');
    }

    public function event()
    {
        return $this->hasOne(Event::class);
    }
    
    public function CommunicationStatus()
    {
        return $this->belongsTo(Status::class, 'status_id');
    }

    public function agent()
    {
        return $this->belongsTo(Agent::class, 'agent_id');
    }
}
