<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Inquiry extends Model
{
    use HasFactory;

    public $guarded = [];
    public $table = 'inquiries';


    public function inqType()
    {
        return $this->belongsTo(InqType::class,'inq_type_id');
    }

    public function broker()
    {
        return $this->belongsTo(Broker::class,'broker_id');
    }
    
    public function agent()
    {
        return $this->belongsTo(Agent::class,'agent_id');
    }

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }

    public function status()
    {
        return $this->belongsTo(Status::class,'status_id');
    }

    public function campaign()
    {
        return $this->belongsTo(Campaign::class,'campaign_id');
    }
    
    public function source()
    {
        return $this->belongsTo(Source::class,'source_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class,'user_id');
    }

}
