<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Schema;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\LogOptions;

class Unit extends Model
{
    use HasFactory;
    use SoftDeletes;
    use LogsActivity;

    public $guarded = [];
    protected $table = 'units';

    public function finishingLevel()
    {
        return $this->hasOne(UnitSetting::class, 'id', 'finishing');
    }

    public function typee()
    {
        return $this->hasOne(UnitSetting::class, 'id', 'type');
    }


    public function vieww()
    {
        return $this->hasOne(UnitSetting::class, 'id', 'view');
    }

    public function actions()
    {
        return $this->hasMany(Action::class);
    }
    
    public function building()
    {
        return $this->belongsTo(Building::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function client()
    {
        return $this->belongsTo(Client::class);
    }

    public function payment()
    {
        return $this->hasOne(Payment::class);
    }

    public function facilities()
    {
        return $this->hasMany(FacilityUnit::class);
    }

    public function contracts()
    {
        return $this->hasMany(ClientContract::class);
    }

    public function tickets()
    {
        return $this->hasMany(Ticket::class);
    }

    public function batches()
    {
        return $this->hasMany(Batch::class);
    }

    public function files()
    {
        return $this->hasMany(File::class);
    }

    public function images()
    {
        return $this->hasMany(Gallery::class);
    }

    public function prices()
    {
        return $this->hasMany(UnitPrice::class);
    }


    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logUnguarded()->logOnlyDirty()->setDescriptionForEvent(fn (string $eventName) => "This model has been {$eventName}")->useLogName('Unit Action');;
    }

    public static function getTableColumns()
    {
        return Schema::getColumnListing((new self)->getTable());
    }
}
