@extends ('welcome')

@section ('content')

<div class="row">

    
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">All Notifications</h3>

            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive p-0">
                <table class="table table-hover text-nowrap">
                    <tbody>
                        @foreach($alerts as $alert)

                        <tr class="clickable" onclick="window.location='{{route('tickets.show', $alert->ticket_id)}}'">
                            <a href="{{route('tickets.show', $alert->ticket_id)}}">
                                <td>
                                    @if($alert->open == 0)
                                    <span style="color:yellow;margin-right:10px;" class="float-left"><i class="fas fa-star"></i>
                                    </span>
                                    @endif
                                    <span class="float-left" style="font-weight: bold;margin-right:10px;">{{$alert->title}}</span>
                                    <span class="float-left text-muted text-sm">{{$alert->body}}</span>
                                    <span class="float-right text-muted text-sm">{{$alert->created_at}}</span>
                                </td>
                            </a>

                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
</div>

@endsection