@extends ('../welcome')


@section ('content')
<div class="card-outline-light col-6">
    <div class="card-header">
        <h3 class="card-title">Unit Reservation for Client:
            <a href="{{route('clients.show', $client->id)}}">{{$client->name}}</a>
        </h3>

        @if(!empty($unit))
            @if($unit->status == 'reserved'||'hold')
            <form action="{{route('reservationContract')}}" method="post">
                @csrf
                <input type="hidden" name="unit_id" value="{{$unit->id}}">
                <input type="hidden" name="client_id" value="{{$client->id}}">
                <button type="submit" class="btn btn-success" title="Reservation Form" style="float:right"><i
                        class="fas fa-file-alt"></i></button>
            </form>
            @endif
        @endif
    </div>
    <div class="card-body">
        <!-- UnitFree -->
        @if($unit == '')
        <div class="unitFree">
            <form method="post" action="{{route('AssignUnit', $client->id)}}">
                <meta name="csrf-token" content="{{ csrf_token() }}">
                @csrf
                <input type="hidden" name="client_id" value="{{$client->id}}">
                <div class="form-group">
                    <label for="project_id">Select Project</label>
                    <select name="project_id" id="projects" class="custom-select form-control-border">
                        <option></option>
                        @foreach($projects as $project)
                        <option value="{{ $project->id }}">{{ $project->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="row" style="margin-left:5px;">
                    <div class="form-group col-4">

                        <label for="unit_id">Choose unit</label>
                        <select name="unit_id" id="units" class="select2 custom-select form-control-border">

                        </select>

                    </div>

                    <div class="form-group col-4">
                        <label for="status" style="margin-left:20px;">status</label>
                        <select name="status" style="margin-left:20px;" id="status"
                            class="custom-select form-control-border">
                            <option value="hold">hold</option>
                            <option value="reserved">reserved</option>
                            <option value="downpayment">downpayment</option>
                        </select>
                    </div>
                </div>
                <label for="facilities" style="margin-left:20px;">Has Facilities ?</label>
                <div id="facilities" style="margin-left:20px;">

                </div>

                <label for="reservation">Reservation Form</label>
                <div id="reservation" class="form-group">
                    <input name="reservation" class="form-control" type="number" step="any">
                </div>
                <br>
                <div class="row" style=" margin-top:70px;margin-left:20%">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
        @endif
        <!-- With Unit -->
        @if(!empty($unit))
        <div class="WithUnit">
            <form method="post" action="{{route('AssignUnit', $client->id)}}">
                @csrf
                <input type="hidden" name="client_id" value="{{$client->id}}">

                <div class="form-group">
                    <label for="project_id">project</label>
                    <input type="text" disabled class="form-control"
                        value="{{$unit->building?->phase?->project?->name}}">
                    <input type="hidden" name="project_id" class="form-control"
                        value="{{$unit->building?->phase?->project?->id}}">
                </div>
                <div class="row" style="margin-left:5px;">
                    <div class="form-group">
                        <label>unit</label>
                        <input class="form-control" disabled value="{{$unit->name}}">
                        <input type="hidden" name="unit_id" class="form-control" value="{{$unit->id}}">

                    </div>

                    <div class="form-group">
                        <label for="status" style="margin-left:20px;">status</label>
                        <select name="status" style="margin-left:20px;" id="status"
                            class="custom-select form-control-border">
                            @if($unit->status == 'hold')
                            <option value="reserved">reserved</option>
                            <option value="downpayment">downpayment</option>
                            @elseif($unit->status == 'reserved')
                            <option value="downpayment">downpayment</option>
                            @elseif($unit->status == 'downpayment')
                            <option value="downpayment">downpayment</option>
                            @else
                            <option value="hold">hold</option>
                            <option value="reserved">reserved</option>
                            <option value="downpayment">downpayment</option>
                            @endif
                        </select>
                    </div>
                </div>
                @if(count($facilities) != 0)
                <label for="facilities" style="margin-left:20px;">Facilities </label>

                @for($i=0; $i < count($facilities); $i++) <li>
                    {{$facilities[$i]['name']}} - {{$facilities[$i]['price']}} - {{$facilities[$i]['price_word']}}
                    </li>
                    @endfor
                    @endif
                    <br>

                    <label for="reservation">Reservation Amount</label>
                    <div id="reservation" class="form-group">
                        <input name="reservation" class="form-control" value="{{$payment->reservation ?? ''}}"
                            type="number" step="any">
                    </div>

                    <label for="reservation">DownPayment Amount</label>
                    <div class="form-group">
                        <input name="down_payment" title="total downpayment = reservation amount + down payment" class="form-control" value="{{$payment->down_payment ?? ''}}"
                            type="number" step="any">
                    </div>

                    <button style="float:right" type="submit" class="btn btn-info">Submit</button>
            </form>
        </div>
        @endif
    </div>
</div>
<!--  -->
<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
<script type="text/javascript">
$(document).on('change', '#projects', function() {
    // console.log(this.value);
    var data = this.value;

    $.ajax({
        data: {
            'project_id': data
        },
        method: "POST",
        url: "{{route('unitReservation')}}",

        success: function(dataResult) {
            var dataResult = JSON.parse(dataResult);
            // console.log(dataResult.units);
            let facilities = "";
            let units = "";
            Array.from(dataResult.facilities).forEach(myFunction);

            function myFunction(item, index) {
                facilities += `
                <div id="inputFormRow">

                    <div class="row">
                            <div class="form-check">
                                <input class="form-check-input " id="facility" name="facility_id[]" value="` + item
                    .id + `"
                                    type="checkbox">
                                <label class="form-check-label">` + item.name + `</label>

                            </div>
                            <div class="form-group">
                                <input class="form-control" name="facility_price[]" id="facility_price" 
                                    type="number" step="any" placeholder="00" disabled>
                            </div>
                                
                            <div class="form-group">
                                <input class="form-control" name="facility_price_word[]" id="facility_price" 
                                    type="text" placeholder="صفر جنيه" disabled>
                            </div>
                            </div>
                    </div>`;
            }
            document.getElementById("facilities").innerHTML = facilities;


            Array.from(dataResult.units).forEach(myFunction2);

            function myFunction2(item, index) {
                units += `<option value="` + item.id + `">` + item.name + `</option>`;
            }
            document.getElementById("units").innerHTML = units;
        }
    });
});
$(document).on('change', '#facility', function() {
    console.log($(this).closest('#inputFormRow').find("input"));
    if ($(this).closest('#inputFormRow').find("input").is(":disabled")) {
        console.log("yes");
        $(this).closest('#inputFormRow').find("input").attr("disabled", false);
    } else {
        console.log("no");
        $(this).closest('#inputFormRow').find("input[type=text]").attr("disabled", true);
        $(this).closest('#inputFormRow').find("input[type=number]").attr("disabled", true);
    }

});
</script><!-- /.card -->
@endsection