@extends ('../welcome')

@section('content')
    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            <div class="card-header">

                <h3 class="card-title">Archived Leads & CILs</h3><br>
                <p>Total: {{ count($leads) }}</p>
                @if (auth()->user()->role->hasPermission('leads-restorAll'))
                    <a href="{{ route('leads.restoreAll') }}" title="Restore All" style="float:right">
                        <button class="btn btn-square btn-outline-success" type="button"><i
                                class="fas fa-trash-restore-alt"></i></button>
                    </a>
                @endif
            </div>
            <div class="card-body">
                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('leads-archive-export') ? 'example1' : 'nonExport' }} 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Status</th>
                            <th>Type</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($leads as $lead)
                            <tr>
                                <td>{{ $lead->id }}</td>
                                <td>{{ $lead->name }}</td>
                                <td>{{ $lead->email }}</td>

                                <td>{{ ucwords($lead->status) }}</td>
                                <td>{{ $lead->type }}</td>
                                <td>{{ $lead->created_at->setTimezone('Africa/Cairo') }}</td>
                                <td>
                                    @if (auth()->user()->role->hasPermission('leads-restore'))
                                        <a class="btn btn-success" title="Restore"
                                            href="{{ route('leads.restore', $lead->id) }}">
                                            <i class="fas fa-trash-restore"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->role->hasPermission('delete-permanently'))
                                        <a href="{{ route('leads.deletePermanently', $lead->id) }}">
                                            <button title="Delete" class="btn btn-danger">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        </a>
                                    @endif
                                </td>
                                
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
