@extends ('../welcome')


@section('content')
    <form action="{{ route('projects.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-6">
                <div class="card">
                    <!-- <div class="card-header">
                        <h3 class="card-title">Create Project</h3>
                    </div> -->
                    <div class="card-body">
                        <!-- text input -->

                        <div class="form-group row">
                            <label class="col-2">Name:</label>
                            <input type="text" name="name" class="form-control col-4" placeholder="Project Name"
                                required>
                            <div class="col-1"></div>


                        </div>
                        <!-- textarea -->
                        <div class="form-group row">
                            <label class="col-2">Description: </label>
                            <textarea class="form-control col-4" name="description" placeholder="Project Description"></textarea>
                        </div>

                        <div class="form-group row">
                            <label class="col-2">Mentainance %:</label>
                            <input type="number" step="any" max="100" name="mentainance"
                                class="form-control col-4" placeholder="00" required>
                        </div>
                        <div class="form-group row">
                            <label class="col-2">Accessible:</label>
                            <select class="select2 custom-select form-control-border access_type col-4">
                                <option value="">Select Type</option>
                                <option value="users">Per User</option>
                                <option value="roles">Per Role</option>
                            </select>
                        </div>
                        <div class="form-group users" style="display: none;">
                            <label>Select Users:</label>
                            <select name="user_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach

                            </select>
                        </div>
                        <div class="form-group roles" style="display: none;">
                            <label>Select Roles:</label>
                            <select name="role_id[]" class="select2 custom-select form-control-border" multiple>
                                @foreach ($roles as $role)
                                    <option value="{{ $role->id }}">{{ $role->name }}</option>
                                @endforeach
                            </select>
                        </div>

                        <!-- <div id="actions" class="row"> -->
                        <div class="row">
                            <div class="custom-file col-6">
                                <label for="logo">Logo</label><br>
                                <input type="file" id="logo" name="logo" accept="image/png, image/jpeg">
                            </div>
                            <div class="form-check col-6" style="margin-top: 5%">
                                <input class="form-check-input" name="is_residential" value="1" type="checkbox">
                                <label class="form-check-label">Residential ?</label>
                            </div>
                        </div>

                        <input type="hidden" name="is_active" value="1">
                        <div style="margin-top:5%">
                            <label>Facilities</label>
                            <div class="row">
                                @foreach ($facilities as $facility)
                                    <div class="col-sm-3">
                                        <div class="form-group">
                                            <div class="form-check">
                                                <input class="form-check-input" name="facility_id[]"
                                                    value="{{ $facility->id }}" type="checkbox">
                                                <label class="form-check-label">{{ $facility->name }}</label>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>

                        <button type="submit" class="btn btn-info" style="float:right;">
                            <span>Submit</span>
                        </button>
                    </div>
                </div>
            </div>

            {{--@if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('projects-paymentPlans-create'))
                <div class="col-6">
                    <div class="card card-danger card-outline">
                        <div class="card-header">
                            <h3 class="card-title">Payment Plans</h3>
                        </div>
                        <div class="card-body">

                            <div class="row">
                                <div class="form-group col-5">
                                    <label>Total Unit</label>
                                    <select name="tu_payment_plan_id" class="select2 custom-select form-control-border"
                                        required>
                                        @foreach ($total_unit as $plan)
                                            <option value="{{ $plan->id }}">{{ $plan->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group col-5">
                                    <label>Mentainance</label>
                                    <select name="m_payment_plan_id" class="select2 custom-select form-control-border"
                                        required>
                                        @foreach ($maintenance as $plan)
                                            <option value="{{ $plan->id }}">{{ $plan->name }}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            @endif--}}
        </div>
    </form>



@endsection
