@extends ('../welcome')


@section('content')
    <div class="card col-6">
        <div class="card-body register-card-body">
            <p class="login-box-msg">Add New Role</p>

            <form action="{{ route('roles.store') }}" method="POST">
                @csrf
                <div class="form-group mb-3">
                    <label>Display Name</label>
                    <input type="text" name="name" class="form-control" placeholder="Name" required autofocus>
                </div>
                <div class="form-group mb-3">
                    <label>Job Description</label>
                    <textarea type="tex" class="form-control" placeholder="Description" rows="7" cols="50"
                        name="description"></textarea>
                </div>
                <div class="form-group">
                    <label for="roles">Select Parent Role</label>
                    <select name="role_id" class="select2 custom-select form-control-border" id="roles">
                        @foreach ($roles as $role)
                            @if (auth()->user()->role?->id == $role?->id)
                                @continue
                            @else
                                <option value="{{ $role->id }}">{{ $role->display_name }}</option>
                            @endif
                        @endforeach
                    </select>
                </div>
                <div class="col-6" style="float:right;">
                    <button type="submit" class="btn btn-primary">Add Role</button>
                </div>
                <!-- /.col -->
        </div>
        </form>
    </div>
    <!-- /.form-box -->
    </div><!-- /.card -->
@endsection
